/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.entity.EntityLaserNode;
import zmaster587.advancedRocketry.event.BlockBreakEvent;
import zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill.AbstractDrill;

class MiningDrill
extends AbstractDrill {
    protected boolean finished = false;
    private EntityLaserNode laser;
    private ForgeChunkManager.Ticket ticketLaser;

    MiningDrill() {
    }

    @Override
    ItemStack[] performOperation() {
        ArrayList stacks = new ArrayList();
        for (int i = 0; i < 9; ++i) {
            int x = (int)this.laser.field_70165_t + i % 3 - 1;
            int z = (int)this.laser.field_70161_v + i / 3 - 1;
            BlockPos laserPos = new BlockPos(x, (int)this.laser.field_70163_u, z);
            IBlockState state = this.laser.field_70170_p.func_180495_p(laserPos);
            BlockBreakEvent.LaserBreakEvent event = new BlockBreakEvent.LaserBreakEvent(x, (int)this.laser.field_70163_u, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) continue;
            if (state.func_185904_a().func_76222_j() || state.func_185904_a().func_76224_d()) {
                this.laser.field_70170_p.func_175656_a(laserPos, Blocks.field_150350_a.func_176223_P());
                continue;
            }
            if (state == Blocks.field_150350_a.func_176223_P()) continue;
            NonNullList items = NonNullList.func_191196_a();
            state.func_177230_c().getDrops(items, (IBlockAccess)this.laser.field_70170_p, laserPos, state, 0);
            if (!state.func_185904_a().func_76218_k() || state.func_177230_c() == Blocks.field_150357_h) continue;
            if (items.isEmpty()) {
                this.laser.field_70170_p.func_175656_a(laserPos, Blocks.field_150350_a.func_176223_P());
                continue;
            }
            stacks.addAll(items);
            this.laser.field_70170_p.func_175656_a(laserPos, Blocks.field_150350_a.func_176223_P());
        }
        boolean blockInWay = false;
        block1: do {
            if (this.laser.field_70163_u < 1.0) {
                this.laser.func_70106_y();
                this.laser = null;
                this.finished = true;
                break;
            }
            this.laser.func_70107_b((int)this.laser.field_70165_t, this.laser.field_70163_u - 1.0, (int)this.laser.field_70161_v);
            for (int i = 0; i < 9; ++i) {
                int x = (int)this.laser.field_70165_t + i % 3 - 1;
                int z = (int)this.laser.field_70161_v + i / 3 - 1;
                BlockPos laserPos = new BlockPos(x, (int)this.laser.field_70163_u, z);
                IBlockState state = this.laser.field_70170_p.func_180495_p(laserPos);
                if (!state.func_185904_a().func_76218_k() || state.func_177230_c() == Blocks.field_150357_h) continue;
                if (state == Blocks.field_150350_a.func_176223_P() || state.func_185904_a().func_76224_d()) {
                    this.laser.field_70170_p.func_175698_g(laserPos);
                    continue;
                }
                if (state == Blocks.field_150350_a.func_176223_P()) continue;
                blockInWay = true;
                continue block1;
            }
        } while (!blockInWay);
        return stacks.toArray(new ItemStack[0]);
    }

    @Override
    boolean activate(World world, int x, int z) {
        this.ticketLaser = ForgeChunkManager.requestTicket((Object)AdvancedRocketry.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.ticketLaser != null) {
            Chunk chunk = world.func_175726_f(new BlockPos(x, 0, z));
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticketLaser, (ChunkPos)new ChunkPos(chunk.field_76635_g, chunk.field_76647_h));
            int y = 64;
            for (int i = 0; i < 9; ++i) {
                int current = world.func_175672_r(new BlockPos(x + i % 3 - 1, 255, z + i / 3 - 1)).func_177956_o();
                if (current <= y) continue;
                y = current;
            }
            this.laser = new EntityLaserNode(world, x, y, z);
            this.laser.markValid();
            this.laser.field_98038_p = true;
            world.func_72838_d((Entity)this.laser);
            return true;
        }
        return false;
    }

    @Override
    void deactivate() {
        if (this.laser != null) {
            this.laser.func_70106_y();
            this.laser = null;
        }
        if (this.ticketLaser != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticketLaser);
        }
        this.finished = false;
    }

    @Override
    boolean isFinished() {
        return this.finished;
    }

    @Override
    boolean needsRestart() {
        return this.laser == null || this.ticketLaser == null;
    }
}

