/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.entity.EntityElevatorCapsule;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.DimensionBlockPosition;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileSpaceElevator
extends TileMultiPowerConsumer
implements IModularInventory,
ILinkableTile,
ITickable {
    private static final byte SUMMON_PACKET = 2;
    private static final int BUTTON_ID_OFFSET = 5;
    Object[][][] structure = new Object[][][]{{{Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('P'), Character.valueOf('c'), Character.valueOf('P'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}, {"blockSteel", Blocks.field_150350_a, Blocks.field_150350_a, "slab", "slab", "slab", Blocks.field_150350_a, Blocks.field_150350_a, "blockSteel"}, {Blocks.field_150350_a, LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab", "slab", "slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150350_a}, {Blocks.field_150350_a, "slab", LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, "slab", Blocks.field_150350_a}, {"slab", "slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab", "slab"}, {"slab", "slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.motors, LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab", "slab"}, {"slab", "slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab", "slab"}, {Blocks.field_150350_a, "slab", LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, "slab", Blocks.field_150350_a}, {Blocks.field_150350_a, LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab", "slab", "slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150350_a}, {"blockSteel", Blocks.field_150350_a, Blocks.field_150350_a, "slab", "slab", "slab", Blocks.field_150350_a, Blocks.field_150350_a, "blockSteel"}}};
    EntityElevatorCapsule capsule = null;
    boolean firstTick = true;
    DimensionBlockPosition dimBlockPos;
    private boolean isTetherConnected;
    private ModuleText landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);

    public TileSpaceElevator() {
        this.landingPadDisplayText.setColor(65280);
        this.dimBlockPos = null;
    }

    public static boolean isDestinationValid(int destinationDimensionID, DimensionBlockPosition pos, HashedBlockPosition myPos, int myDimensionID) {
        if (pos == null || pos.pos == null) {
            return false;
        }
        if (myDimensionID == ARConfiguration.getCurrentConfig().spaceDimId && SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPos.getBlockPos()) != null) {
            return PlanetaryTravelHelper.isTravelWithinGeostationaryOrbit((SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPos.getBlockPos()), pos.dimid);
        }
        if (pos.dimid == ARConfiguration.getCurrentConfig().spaceDimId && SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos.pos.getBlockPos()) != null) {
            return PlanetaryTravelHelper.isTravelWithinGeostationaryOrbit((SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos.pos.getBlockPos()), myDimensionID);
        }
        return false;
    }

    public static boolean wouldTetherBreakOnConnect(int destinationDimensionID, DimensionBlockPosition pos, HashedBlockPosition myPos, int myDimensionID) {
        SpaceStationObject spaceStation = myDimensionID == ARConfiguration.getCurrentConfig().spaceDimId ? (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPos.getBlockPos()) : (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos.pos.getBlockPos());
        return spaceStation != null && spaceStation.wouldStationBreakTether();
    }

    public void deconstructMultiBlock(World world, BlockPos destroyedPos, boolean blockBroken, IBlockState state) {
        TileEntity tile;
        super.deconstructMultiBlock(world, destroyedPos, blockBroken, state);
        WorldServer otherPlanet = DimensionManager.getWorld((int)this.dimBlockPos.dimid);
        if (otherPlanet == null) {
            DimensionManager.initDimension((int)this.dimBlockPos.dimid);
            otherPlanet = DimensionManager.getWorld((int)this.dimBlockPos.dimid);
        }
        if (otherPlanet != null && (tile = otherPlanet.func_175625_s(this.dimBlockPos.pos.getBlockPos())) instanceof TileSpaceElevator) {
            ((TileSpaceElevator)tile).updateTetherLinkPosition(this.dimBlockPos, null);
            this.updateTetherLinkPosition(new DimensionBlockPosition(world.field_73011_w.getDimension(), new HashedBlockPosition(this.func_174877_v())), null);
        }
    }

    public Object[][][] getStructure() {
        return this.structure;
    }

    public String getMachineName() {
        return this.getModularInventoryName();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -300, -5), this.field_174879_c.func_177982_a(5, 3000, 5));
    }

    public boolean shouldHideBlock(World world, BlockPos pos, IBlockState tile) {
        return true;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        if (ID == GuiHandler.guiId.MODULAR.ordinal()) {
            modules.add(new ModuleButton(50, 47, 1, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.button.summon"), (IButtonInventory)this, TextureResources.buttonBuild, 80, 18));
            if (this.isTetherConnected()) {
                modules.add(new ModuleText(30, 23, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.warning.anchored0"), 0x2D2D2D));
                modules.add(new ModuleText(30, 35, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.warning.anchored1"), 0x2D2D2D));
            } else {
                modules.add(new ModuleText(30, 32, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.warning.unanchored"), 0x2D2D2D));
            }
        }
        return modules;
    }

    public boolean attemptLaunch() {
        if (!(this.isComplete() && this.enabled && this.hasEnergy(50000))) {
            return false;
        }
        this.useEnergy(50000);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 1) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
        }
        if (buttonId >= 5) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)buttonId));
        }
        super.onInventoryButtonPressed(buttonId);
    }

    public void notifyLanded(EntityElevatorCapsule e) {
        if (this.capsule != null && this.capsule != e && !this.capsule.field_70128_L) {
            e.func_70106_y();
        } else {
            this.capsule = e;
            this.capsule.setSourceTile(new DimensionBlockPosition(this.field_145850_b.field_73011_w.getDimension(), new HashedBlockPosition(this.field_174879_c)));
            this.capsule.setDst(this.dimBlockPos);
        }
        int yOffset = this.isAnchorOnSpaceStation() ? -5 : 1;
        this.capsule.func_70107_b(this.getLandingLocationX(), this.func_174877_v().func_177956_o() + yOffset, this.getLandingLocationZ());
        this.rotateCapsule();
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 2) {
            this.summonCapsule();
        } else if (id == 5) {
            this.dimBlockPos = null;
            this.capsule.setDst(null);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        super.useNetworkData(player, side, id, nbt);
    }

    public EntityElevatorCapsule getCapsuleOnLine() {
        if (this.capsule != null && this.capsule.field_70128_L) {
            this.capsule = null;
        }
        double capsulePosX = this.getLandingLocationX();
        double capsulePosZ = this.getLandingLocationZ();
        for (EntityElevatorCapsule e : this.field_145850_b.func_72872_a(EntityElevatorCapsule.class, new AxisAlignedBB(capsulePosX - 3.0, 0.0, capsulePosZ - 3.0, capsulePosX + 3.0, EntityElevatorCapsule.MAX_HEIGHT, capsulePosZ + 3.0))) {
            if (e.field_70128_L) continue;
            this.capsule = e;
            break;
        }
        return this.capsule;
    }

    public double getLandingLocationX() {
        EnumFacing facing = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        return (double)(this.func_174877_v().func_177958_n() + facing.func_82601_c() * -5 - facing.func_82599_e() * 2) + 0.5;
    }

    public double getLandingLocationZ() {
        EnumFacing facing = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        return (double)(this.func_174877_v().func_177952_p() + facing.func_82601_c() * 2 + facing.func_82599_e() * -5) + 0.5;
    }

    public void rotateCapsule() {
        EnumFacing facing = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        switch (facing) {
            case EAST: {
                this.capsule.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                this.capsule.field_70177_z = 90.0f;
                break;
            }
            case NORTH: {
                this.capsule.field_70177_z = 270.0f;
                break;
            }
            default: {
                this.capsule.field_70177_z = 0.0f;
            }
        }
    }

    public void summonCapsule() {
        TileEntity tile;
        if (!this.isTetherConnected()) {
            return;
        }
        while (this.getCapsuleOnLine() != null) {
            this.getCapsuleOnLine().func_70106_y();
        }
        WorldServer otherPlanet = DimensionManager.getWorld((int)this.dimBlockPos.dimid);
        if (otherPlanet == null) {
            DimensionManager.initDimension((int)this.dimBlockPos.dimid);
            otherPlanet = DimensionManager.getWorld((int)this.dimBlockPos.dimid);
        }
        if (otherPlanet != null && (tile = otherPlanet.func_175625_s(this.dimBlockPos.pos.getBlockPos())) instanceof TileSpaceElevator && ((TileSpaceElevator)tile).getCapsuleOnLine() != null) {
            ((TileSpaceElevator)tile).getCapsuleOnLine().func_70106_y();
        }
        this.capsule = new EntityElevatorCapsule(this.field_145850_b);
        this.rotateCapsule();
        double capsulePosX = this.getLandingLocationX();
        double capsulePosZ = this.getLandingLocationZ();
        int yOffset = this.isAnchorOnSpaceStation() ? -4 : 1;
        this.capsule.func_70107_b(capsulePosX, this.func_174877_v().func_177956_o() + yOffset, capsulePosZ);
        this.capsule.setDst(this.dimBlockPos);
        this.capsule.setSourceTile(new DimensionBlockPosition(this.field_145850_b.field_73011_w.getDimension(), new HashedBlockPosition(this.func_174877_v())));
        this.field_145850_b.func_72838_d((Entity)this.capsule);
    }

    public boolean onLinkStart(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        ItemLinker.setDimId((ItemStack)item, (int)world.field_73011_w.getDimension());
        if (this.dimBlockPos != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.linkCannotChangeError", new Object[0]));
            return false;
        }
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.linker.program", new Object[0]));
        }
        return true;
    }

    public boolean onLinkComplete(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World myWorld) {
        if (!myWorld.field_72995_K) {
            TileEntity tile;
            int dimid = ItemLinker.getDimId((ItemStack)item);
            BlockPos pos = ItemLinker.getMasterCoords((ItemStack)item);
            DimensionBlockPosition dimPos = new DimensionBlockPosition(dimid, new HashedBlockPosition(pos));
            if (dimPos.dimid == this.field_145850_b.field_73011_w.getDimension()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.sameDimensionError", new Object[0]));
                return false;
            }
            WorldServer world = DimensionManager.getWorld((int)dimPos.dimid);
            if (world == null) {
                DimensionManager.initDimension((int)dimPos.dimid);
                world = DimensionManager.getWorld((int)dimPos.dimid);
            }
            if (!TileSpaceElevator.isDestinationValid(dimPos.dimid, dimPos, new HashedBlockPosition(this.func_174877_v()), myWorld.field_73011_w.getDimension())) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.linkNotGeostationaryError", new Object[0]));
                return false;
            }
            if (TileSpaceElevator.wouldTetherBreakOnConnect(dimPos.dimid, dimPos, new HashedBlockPosition(this.func_174877_v()), myWorld.field_73011_w.getDimension())) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.tetherWouldBreakError", new Object[0]));
                return false;
            }
            if (this.dimBlockPos != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.linkCannotChangeError", new Object[0]));
                return false;
            }
            if (world != null && (tile = world.func_175625_s(dimPos.pos.getBlockPos())) instanceof TileSpaceElevator) {
                this.updateTetherLinkPosition(new DimensionBlockPosition(this.field_145850_b.field_73011_w.getDimension(), new HashedBlockPosition(this.func_174877_v())), dimPos);
                ((TileSpaceElevator)tile).updateTetherLinkPosition(dimPos, new DimensionBlockPosition(this.field_145850_b.field_73011_w.getDimension(), new HashedBlockPosition(this.func_174877_v())));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.newDstAdded", new Object[0]));
                if (this.capsule != null) {
                    this.capsule.setDst(this.dimBlockPos);
                }
                this.func_70296_d();
                this.field_145850_b.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                this.isTetherConnected = true;
                return true;
            }
        }
        return false;
    }

    public boolean isAnchorOnSpaceStation() {
        return this.field_145850_b.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId;
    }

    public void updateTetherLinkPosition(DimensionBlockPosition myPosition, DimensionBlockPosition dimensionBlockPosition) {
        if (myPosition.dimid == ARConfiguration.getCurrentConfig().spaceDimId && SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()) != null) {
            if (dimensionBlockPosition != null) {
                SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()).setDeltaRotation(0.0, EnumFacing.EAST);
                SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()).setDeltaRotation(0.0, EnumFacing.UP);
                SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()).setDeltaRotation(0.0, EnumFacing.NORTH);
            }
            SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()).setIsAnchored(dimensionBlockPosition != null);
        }
        if (dimensionBlockPosition == null) {
            this.isTetherConnected = false;
            EntityElevatorCapsule entity = this.getCapsuleOnLine();
            if (entity != null) {
                entity.func_70106_y();
            }
        } else {
            this.isTetherConnected = true;
        }
        this.dimBlockPos = dimensionBlockPosition;
    }

    public boolean isTetherConnected() {
        return this.isTetherConnected;
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockSpaceElevatorController.func_149732_F();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void writeNetworkData(NBTTagCompound nbt) {
        if (this.dimBlockPos != null) {
            nbt.func_74768_a("dstDimId", this.dimBlockPos.dimid);
            nbt.func_74783_a("dstPos", new int[]{this.dimBlockPos.pos.x, this.dimBlockPos.pos.y, this.dimBlockPos.pos.z});
            nbt.func_74757_a("tether", this.isTetherConnected);
            super.writeNetworkData(nbt);
        } else {
            super.writeNetworkData(nbt);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public void readNetworkData(NBTTagCompound nbt) {
        super.readNetworkData(nbt);
        if (nbt.func_74764_b("dstDimId")) {
            int id = nbt.func_74762_e("dstDimId");
            int[] pos = nbt.func_74759_k("dstPos");
            this.dimBlockPos = new DimensionBlockPosition(id, new HashedBlockPosition(pos[0], pos[1], pos[2]));
        } else {
            this.dimBlockPos = null;
        }
        this.isTetherConnected = nbt.func_74767_n("tether");
        this.landingPadDisplayText.setText(this.dimBlockPos != null ? this.dimBlockPos.toString() : LibVulpes.proxy.getLocalizedString("msg.label.noneSelected"));
    }
}

