/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import zmaster587.advancedRocketry.tile.TileEntitySyncable;
import zmaster587.advancedRocketry.util.IBrokenPartBlock;

public class TileBrokenPart
extends TileEntitySyncable {
    private int stage;
    private int maxStage;
    private float transitionProb;
    private float[] probs;
    private final Random rand;

    public TileBrokenPart() {
        this(0, 0.0f);
    }

    public TileBrokenPart(int stage, int maxStage, float transitionProb, Random rand) {
        this.stage = stage;
        this.maxStage = maxStage;
        this.rand = rand;
        this.initProb(transitionProb);
    }

    public TileBrokenPart(int maxStage, float transitionProb, Random rand) {
        this(0, maxStage, transitionProb, rand);
    }

    public TileBrokenPart(int maxStage, float transitionProb) {
        this(maxStage, transitionProb, new Random());
    }

    public void setStage(int stage) {
        this.stage = stage;
        this.func_70296_d();
    }

    public int getStage() {
        return this.stage;
    }

    private void initProb(float transitionProb) {
        this.transitionProb = transitionProb;
        this.probs = new float[this.maxStage];
        for (int i = 0; i < this.maxStage; ++i) {
            this.probs[i] = transitionProb / (float)Math.sqrt(2 * i + 1);
        }
    }

    public boolean transition() {
        if (this.stage == this.maxStage) {
            return true;
        }
        for (int i = this.maxStage - 1; i >= 0; --i) {
            if (this.stage == i) {
                return false;
            }
            if (!(this.rand.nextFloat() < (float)(this.stage + 1) * this.probs[i])) continue;
            this.stage = i;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public ItemStack getDrop() {
        return ((IBrokenPartBlock)this.func_145838_q()).getDropItem(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("stage", this.stage);
        compound.func_74768_a("maxStage", this.maxStage);
        compound.func_74776_a("transitionProb", this.transitionProb);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stage = compound.func_74762_e("stage");
        this.maxStage = compound.func_74762_e("maxStage");
        this.transitionProb = compound.func_74760_g("transitionProb");
        this.initProb(this.transitionProb);
    }
}

