/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.network.BasePacket;

public class PacketSyncKnownPlanets
extends BasePacket {
    public int stationId;
    private Set<Integer> knownPlanets;

    public PacketSyncKnownPlanets() {
    }

    public PacketSyncKnownPlanets(int stationId, Set<Integer> knownPlanets) {
        this.stationId = stationId;
        this.knownPlanets = knownPlanets;
        this.knownPlanets.addAll(DimensionManager.getInstance().knownPlanets);
    }

    public void write(ByteBuf out) {
        PacketBuffer buffer = new PacketBuffer(out);
        buffer.writeInt(this.stationId);
        buffer.writeInt(this.knownPlanets.size());
        for (Integer planetId : this.knownPlanets) {
            buffer.writeInt(planetId.intValue());
        }
    }

    public void readClient(ByteBuf in) {
        PacketBuffer buffer = new PacketBuffer(in);
        this.stationId = buffer.readInt();
        int size = buffer.readInt();
        this.knownPlanets = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            this.knownPlanets.add(buffer.readInt());
        }
    }

    public void read(ByteBuf in) {
    }

    public void executeClient(EntityPlayer player) {
        SpaceStationObject spaceObject = (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStation(this.stationId);
        if (spaceObject != null) {
            spaceObject.getKnownPlanetList().clear();
            spaceObject.getKnownPlanetList().addAll(this.knownPlanets);
        }
    }

    public void executeServer(EntityPlayerMP player) {
    }
}

