/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.libVulpes.network.BasePacket;

public class PacketSatellitesUpdate
extends BasePacket {
    private int dimNumber;
    private DimensionProperties dimProperties;

    public PacketSatellitesUpdate() {
    }

    public PacketSatellitesUpdate(int dimNumber, DimensionProperties dimProperties) {
        this.dimProperties = dimProperties;
        this.dimNumber = dimNumber;
    }

    public void write(ByteBuf byteBuf) {
        byteBuf.writeInt(this.dimNumber);
        NBTTagCompound compound = new NBTTagCompound();
        for (SatelliteBase satellite : this.dimProperties.getTickingSatellites()) {
            NBTTagCompound satTag = new NBTTagCompound();
            satellite.writeToNBT(satTag);
            compound.func_74782_a(String.valueOf(satellite.getId()), (NBTBase)satTag);
        }
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)compound);
    }

    public void readClient(ByteBuf byteBuf) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            System.out.println("readclient was called on server side (this should never happen) - returning");
            return;
        }
        int dimNumber = byteBuf.readInt();
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)byteBuf);
        DimensionProperties prop = DimensionManager.getInstance().getDimensionProperties(dimNumber);
        for (String key : compound.func_150296_c()) {
            prop.getSatellite(Long.parseLong(key)).readFromNBT(compound.func_74775_l(key));
        }
    }

    public void read(ByteBuf byteBuf) {
    }

    public void executeClient(EntityPlayer entityPlayer) {
    }

    public void executeServer(EntityPlayerMP entityPlayerMP) {
    }
}

