/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.inventory.modules;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ModuleBrokenPart
extends ModuleBase {
    private final ItemStack part;

    public ModuleBrokenPart(int offsetX, int offsetY, @Nonnull ItemStack part) {
        super(offsetX, offsetY);
        this.part = part;
        this.sizeX = 18;
        this.sizeY = 18;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(CommonResources.genericBackground);
        gui.func_73729_b(x + this.offsetX - 1, y + this.offsetY - 1, 176, 0, 18, 18);
        int relativeX = x + this.offsetX;
        int relativeY = y + this.offsetY;
        int zLevel = 500;
        GL11.glPushMatrix();
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        GL11.glTranslatef((float)relativeX, (float)relativeY, (float)zLevel);
        Minecraft.func_71410_x().func_175599_af().func_175042_a(this.part, 0, 0);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(font, this.part, 0, 0, "");
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        return relativeX > 0 && relativeX < this.sizeX && relativeY > 0 && relativeY < this.sizeY;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderToolTip(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
        super.renderToolTip(guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        if (this.part != null && this.isMouseOver(mouseX, mouseY)) {
            List<String> list = Arrays.asList(LibVulpes.proxy.getLocalizedString(this.part.func_77977_a() + ".name"), LibVulpes.proxy.getLocalizedString("msg.brokenstage.text") + ": " + this.part.func_77952_i() / 3);
            this.drawTooltip(gui, list, mouseX, mouseY, zLevel, font);
        }
    }
}

