/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import java.nio.IntBuffer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.armor.IFillableArmor;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.client.render.ClientDynamicTexture;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.util.ItemAirUtils;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.client.ResourceIcon;
import zmaster587.libVulpes.render.RenderHelper;

public class RocketEventHandler
extends Gui {
    private static final int getImgSize = 512;
    private static final int outerImgSize = 64;
    private static final int numTicksToDisplay = 100;
    public static GuiBox suitPanel = new GuiBox(8, 8, 24, 24);
    public static GuiBox oxygenBar = new GuiBox(8, -57, 80, 48);
    public static GuiBox hydrogenBar = new GuiBox(8, -74, 80, 48);
    public static GuiBox atmBar = new GuiBox(8, 27, 200, 48);
    private static ClientDynamicTexture earth;
    private static ClientDynamicTexture outerBounds;
    private static boolean mapReady;
    private static boolean mapNeedsBinding;
    private static IntBuffer table;
    private static IntBuffer outerBoundsTable;
    private static IRenderHandler prevRenderHanlder;
    private static GuiBox currentlySelectedBox;
    private static String displayString;
    private static long lastDisplayTime;
    Thread thread = null;
    private ResourceLocation background = TextureResources.rocketHud;

    @SideOnly(value=Side.CLIENT)
    public static void setOverlay(long endTime, String msg) {
        displayString = msg;
        lastDisplayTime = endTime;
    }

    @SubscribeEvent
    public void playerTeleportEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        lastDisplayTime = -1000L;
    }

    @SubscribeEvent
    public void onScreenRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            FontRenderer fontRenderer;
            Entity ride = Minecraft.func_71410_x().field_71439_g.func_184187_bx();
            if (ride instanceof EntityRocket) {
                EntityRocket rocket = (EntityRocket)ride;
                GlStateManager.func_179147_l();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.background);
                this.func_73729_b(0, 0, 0, 0, 17, 252);
                float percentOrbit = MathHelper.func_76131_a((float)((float)((rocket.field_70163_u - (double)rocket.field_70170_p.field_73011_w.func_76557_i()) / (double)(ARConfiguration.getCurrentConfig().orbit - rocket.field_70170_p.field_73011_w.func_76557_i()))), (float)0.0f, (float)1.0f);
                this.func_73729_b(3, 8 + (int)(79.0f * (1.0f - percentOrbit)), 17, 0, 6, 6);
                this.func_73729_b(3, 94 + (int)(69.0 * (0.5 - (double)(MathHelper.func_76131_a((float)((float)rocket.field_70181_x), (float)-1.0f, (float)1.0f) / 2.0f))), 17, 0, 6, 6);
                int size = (int)(68.0f * rocket.getNormallizedProgress(0));
                this.func_73729_b(3, 242 - size, 17, 75 - size, 3, size);
                GlStateManager.func_179084_k();
                String str = rocket.getTextOverlay();
                if (!str.isEmpty()) {
                    String[] strs = str.split("\n");
                    int vertPos = 0;
                    for (String strPart : strs) {
                        FontRenderer fontRenderer2 = Minecraft.func_71410_x().field_71466_p;
                        float scale = str.length() < 50 ? 1.0f : 0.5f;
                        int screenX = (int)((float)event.getResolution().func_78326_a() / (scale * 6.0f) - (float)(fontRenderer2.func_78256_a(strPart) / 2));
                        int screenY = (int)((float)(event.getResolution().func_78328_b() / 18) / scale) + 18 * vertPos;
                        GL11.glPushMatrix();
                        GL11.glScalef((float)(scale * 3.0f), (float)(scale * 3.0f), (float)(scale * 3.0f));
                        fontRenderer2.func_175063_a(strPart, (float)screenX, (float)screenY, 0xFFFFFF);
                        GL11.glPopMatrix();
                        ++vertPos;
                    }
                }
            }
            if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && !Minecraft.func_71410_x().field_71439_g.func_175149_v()) {
                EntityEquipmentSlot[] chestPiece = Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
                IFillableArmor fillable = null;
                if (!chestPiece.func_190926_b() && chestPiece.func_77973_b() instanceof IFillableArmor) {
                    fillable = (IFillableArmor)chestPiece.func_77973_b();
                } else if (ItemAirUtils.INSTANCE.isStackValidAirContainer((ItemStack)chestPiece)) {
                    fillable = new ItemAirUtils.ItemAirWrapper((ItemStack)chestPiece);
                }
                if (fillable != null) {
                    float size = (float)fillable.getAirRemaining((ItemStack)chestPiece) / (float)fillable.getMaxAir((ItemStack)chestPiece);
                    GlStateManager.func_179147_l();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(this.background);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    int width = 83;
                    int screenX = oxygenBar.getRenderX();
                    int screenY = oxygenBar.getRenderY();
                    this.func_73729_b(screenX, screenY, 23, 0, width, 17);
                    this.func_73729_b(screenX, screenY, 23, 17, (int)((float)width * size), 17);
                }
            }
            if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && !Minecraft.func_71410_x().field_71439_g.func_175149_v() && !Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof IModularArmor) {
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    this.renderModuleSlots(Minecraft.func_71410_x().field_71439_g.func_184582_a(slot), 4 - slot.func_188454_b(), (RenderGameOverlayEvent)event);
                }
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - AtmosphereHandler.lastSuffocationTime < 0L) {
                AtmosphereHandler.lastSuffocationTime = 0L;
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - AtmosphereHandler.lastSuffocationTime < 100L) {
                fontRenderer = Minecraft.func_71410_x().field_71466_p;
                String str = "";
                if (AtmosphereHandler.currentAtm != null) {
                    str = AtmosphereHandler.currentAtm.getDisplayMessage();
                }
                int screenX = event.getResolution().func_78326_a() / 6 - fontRenderer.func_78256_a(str) / 2;
                int screenY = event.getResolution().func_78328_b() / 18;
                GL11.glPushMatrix();
                GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
                fontRenderer.func_175063_a(str, (float)screenX, (float)screenY, 0xFF5656);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.progressBars);
                this.func_73729_b(screenX + fontRenderer.func_78256_a(str) / 2 - 8, screenY - 16, 0, 156, 16, 16);
                GL11.glPopMatrix();
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() <= lastDisplayTime) {
                fontRenderer = Minecraft.func_71410_x().field_71466_p;
                GL11.glPushMatrix();
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                int loc = 0;
                for (String str : displayString.split("\n")) {
                    int screenX = event.getResolution().func_78326_a() / 4 - fontRenderer.func_78256_a(str) / 2;
                    int screenY = event.getResolution().func_78328_b() / 12 + loc * event.getResolution().func_78328_b() / 12;
                    fontRenderer.func_175063_a(str, (float)screenX, (float)screenY, 0xFF5656);
                    ++loc;
                }
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    private void renderModuleSlots(@Nonnull ItemStack armorStack, int slot, RenderGameOverlayEvent event) {
        boolean modularArmorFlag;
        int index = 1;
        float color = 0.85f + 0.15f * MathHelper.func_76126_a((float)((float)Math.PI * 2 * (float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 60L) / 60.0f));
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        float alpha = 0.6f;
        if (!armorStack.func_190926_b() && ((modularArmorFlag = armorStack.func_77973_b() instanceof IModularArmor) || ItemAirUtils.INSTANCE.isStackValidAirContainer(armorStack))) {
            int size = 24;
            int screenY = suitPanel.getRenderY() + (slot - 1) * (size + 8);
            int screenX = suitPanel.getRenderX();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)(this.field_73735_i - 1.0f), (double)(screenX - 4), (double)(screenY - 4), (double)(screenX + size), (double)(screenY + size + 4), (double)0.0, (double)0.5, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)(this.field_73735_i - 1.0f), (double)(screenX + size), (double)(screenY - 3), (double)(screenX + 2 + size), (double)(screenY + size + 3), (double)0.5, (double)0.5, (double)0.0, (double)0.0);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179131_c((float)color, (float)color, (float)color, (float)color);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.armorSlots[slot - 1]);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)(this.field_73735_i - 1.0f), (double)screenX, (double)screenY, (double)(screenX + size), (double)(screenY + size), (double)0.0, (double)1.0, (double)1.0, (double)0.0);
            Tessellator.func_178181_a().func_78381_a();
            if (modularArmorFlag) {
                List stacks = ((IModularArmor)armorStack.func_77973_b()).getComponents(armorStack);
                for (ItemStack stack : stacks) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ((IArmorComponent)stack.func_77973_b()).renderScreen(stack, stacks, event, (Gui)this);
                    ResourceIcon icon = ((IArmorComponent)stack.func_77973_b()).getComponentIcon(stack);
                    ResourceLocation texture = null;
                    if (icon != null) {
                        texture = icon.getResourceLocation();
                    }
                    screenX = suitPanel.getRenderX() + 4 + index * (size + 2);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)(this.field_73735_i - 1.0f), (double)(screenX - 4), (double)(screenY - 4), (double)(screenX + size - 2), (double)(screenY + size + 4), (double)0.5, (double)0.5, (double)0.0, (double)1.0);
                    Tessellator.func_178181_a().func_78381_a();
                    if (texture != null) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
                        GlStateManager.func_179131_c((float)color, (float)color, (float)color, (float)alpha);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)(this.field_73735_i - 1.0f), (double)screenX, (double)screenY, (double)(screenX + size), (double)(screenY + size), (double)icon.func_94209_e(), (double)icon.func_94212_f(), (double)icon.func_94210_h(), (double)icon.func_94206_g());
                        Tessellator.func_178181_a().func_78381_a();
                    } else {
                        GL11.glPushMatrix();
                        GlStateManager.func_179109_b((float)screenX, (float)screenY, (float)0.0f);
                        GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, 0, 0);
                        GL11.glPopMatrix();
                    }
                    ++index;
                }
            }
            screenX = index * (size + 2) + suitPanel.getRenderX() - 12;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)(this.field_73735_i - 1.0f), (double)(screenX + 12), (double)(screenY - 4), (double)(screenX + size), (double)(screenY + size + 4), (double)0.75, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179118_c();
    }

    static {
        mapReady = false;
        mapNeedsBinding = false;
        prevRenderHanlder = null;
        currentlySelectedBox = null;
        displayString = "";
        lastDisplayTime = -1000L;
    }

    public static class GuiBox {
        int modeX = -1;
        int modeY = -1;
        int sizeX;
        int sizeY;
        boolean isVisible = true;
        private int x;
        private int y;

        public GuiBox(int x, int y, int sizeX, int sizeY) {
            this.setRawX(x);
            this.setRawY(y);
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }

        public int getX(int scaledW) {
            if (this.modeX == 1) {
                return scaledW - this.getRawX();
            }
            if (this.modeX == 0) {
                return scaledW / 2 - this.getRawX();
            }
            return this.getRawX();
        }

        public int getY(int scaledH) {
            if (this.modeY == 1) {
                return scaledH - this.getRawY();
            }
            if (this.modeY == 0) {
                return scaledH / 2 - this.getRawY();
            }
            return this.getRawY();
        }

        public void setRenderX(int x, double scaleX) {
            if ((double)x < scaleX / 3.0) {
                this.modeX = -1;
                this.setRawX(x);
            } else if ((double)x > scaleX * 2.0 / 3.0) {
                this.setRawX((int)(scaleX - (double)x));
                this.modeX = 1;
            } else {
                this.setRawX((int)(scaleX / 2.0 - (double)x));
                this.modeX = 0;
            }
        }

        public void setRenderY(int y, double scaleY) {
            if ((double)y < scaleY / 3.0) {
                this.modeY = -1;
                this.setRawY(y);
            } else if ((double)y > scaleY * 2.0 / 3.0) {
                this.setRawY((int)(scaleY - (double)y));
                this.modeY = 1;
            } else {
                this.setRawY((int)(scaleY / 2.0 - (double)y));
                this.modeY = 0;
            }
        }

        public int getRenderX() {
            ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
            int i = scaledresolution.func_78326_a();
            if (this.modeX == 1) {
                return i - this.getRawX();
            }
            if (this.modeX == 0) {
                return i / 2 - this.getRawX();
            }
            return this.getRawX();
        }

        public int getRenderY() {
            ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
            int i = scaledresolution.func_78328_b();
            if (this.modeY == 1) {
                return i - this.getRawY();
            }
            if (this.modeY == 0) {
                return i / 2 - this.getRawY();
            }
            return this.getRawY();
        }

        public int getRawX() {
            return this.x;
        }

        public void setRawX(int x) {
            this.x = x;
        }

        public int getRawY() {
            return this.y;
        }

        public void setRawY(int y) {
            this.y = y;
        }

        public int getSizeModeX() {
            return this.modeX;
        }

        public void setSizeModeX(int int1) {
            this.modeX = int1;
        }

        public int getSizeModeY() {
            return this.modeY;
        }

        public void setSizeModeY(int int1) {
            this.modeY = int1;
        }
    }
}

