/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.advancements.ARAdvancements;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.dimension.watersourcelocked;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.network.PacketConfigSync;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStellarInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class PlanetEventHandler {
    private static final ItemStack component = new ItemStack(AdvancedRocketryItems.itemUpgrade, 1, 4);
    public static long time = 0L;
    private static long endTime;
    private static long duration;
    private static List<TransitionEntity> transitionMap;

    public static void addDelayedTransition(TransitionEntity entity) {
        transitionMap.add(entity);
    }

    @SideOnly(value=Side.CLIENT)
    public static void runBurst(long endTime, long duration) {
        PlanetEventHandler.endTime = endTime;
        PlanetEventHandler.duration = duration;
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (!event.crafting.func_190926_b()) {
            Item item = event.crafting.func_77973_b();
        }
    }

    @SubscribeEvent
    public void CheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        DimensionProperties properties;
        World world = event.getWorld();
        DimensionManager manager = DimensionManager.getInstance();
        if (manager.isInitialized() && (properties = manager.getDimensionProperties(world.field_73011_w.getDimension())) != null && !properties.getAtmosphere().isImmune(event.getEntityLiving().getClass())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void SpawnEntity(WorldEvent.PotentialSpawns event) {
        List<SpawnListEntryNBT> entries;
        World world = event.getWorld();
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension());
        if (properties != null && !(entries = properties.getSpawnListEntries()).isEmpty() && event.getType() != EnumCreatureType.MONSTER) {
            event.getList().addAll(entries);
        }
    }

    @SubscribeEvent
    public void onWorldGen(OreGenEvent.GenerateMinable event) {
        if (event.getWorld().field_73011_w instanceof WorldProviderPlanet && DimensionManager.getInstance().getDimensionProperties(event.getWorld().field_73011_w.getDimension()).getOreGenProperties(event.getWorld()) != null) {
            switch (event.getType()) {
                case COAL: 
                case DIAMOND: 
                case EMERALD: 
                case GOLD: 
                case IRON: 
                case LAPIS: 
                case QUARTZ: 
                case REDSTONE: 
                case CUSTOM: {
                    event.setResult(Event.Result.DENY);
                    break;
                }
                default: {
                    event.setResult(Event.Result.DEFAULT);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().func_70090_H() && AtmosphereType.LOWOXYGEN.isImmune(event.getEntityLiving())) {
            event.getEntity().func_70050_g(300);
        }
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity().field_70170_p.func_82737_E() % 20L == 0L && event.getEntity() instanceof EntityPlayer && DimensionManager.getInstance().getDimensionProperties(event.getEntity().field_70170_p.field_73011_w.getDimension()).getName().equals("Luna") && event.getEntity().func_180425_c().func_177954_c(2347.0, 80.0, 67.0) < 512.0) {
            ARAdvancements.WENT_TO_THE_MOON.trigger((EntityPlayerMP)event.getEntity());
        }
        if (event.getEntity() instanceof EntityPlayer && event.getEntity().field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(event.getEntity().func_180425_c()) == null && !(event.getEntity().func_184187_bx() instanceof EntityRocket)) {
            double distance = 0.0;
            HashedBlockPosition teleportPosition = null;
            for (ISpaceObject spaceObject : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
                if (!(spaceObject instanceof SpaceStationObject)) continue;
                SpaceStationObject station = (SpaceStationObject)spaceObject;
                double distanceTo = event.getEntity().func_180425_c().func_185332_f(station.getSpawnLocation().x, (int)station.getSpawnLocation().y, station.getSpawnLocation().z);
                if (!(distanceTo > distance)) continue;
                distance = distanceTo;
                teleportPosition = station.getSpawnLocation();
            }
            if (teleportPosition != null) {
                event.getEntity().func_145747_a((ITextComponent)new TextComponentString(LibVulpes.proxy.getLocalizedString("msg.chat.nostation1")));
                event.getEntity().func_145747_a((ITextComponent)new TextComponentString(LibVulpes.proxy.getLocalizedString("msg.chat.nostation2")));
                event.getEntity().func_70634_a((double)teleportPosition.x, (double)teleportPosition.y, (double)teleportPosition.z);
            } else {
                event.getEntity().func_145747_a((ITextComponent)new TextComponentString(LibVulpes.proxy.getLocalizedString("msg.chat.nostation3")));
                event.getEntity().func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)event.getEntity(), 0, (Teleporter)new TeleporterNoPortal(net.minecraftforge.common.DimensionManager.getWorld((int)0)));
            }
        }
    }

    @SubscribeEvent
    public void sleepEvent(@Nonnull PlayerSleepInBedEvent event) {
        if (event.getEntity().field_70170_p.field_73011_w instanceof WorldProviderPlanet) {
            WorldProvider provider = event.getEntity().field_70170_p.field_73011_w;
            AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(provider.getDimension());
            if (!ARConfiguration.getCurrentConfig().forcePlayerRespawnInSpace && AtmosphereHandler.hasAtmosphereHandler(provider.getDimension()) && atmhandler != null && !atmhandler.getAtmosphereType(event.getPos()).isBreathable()) {
                event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            }
        }
    }

    @SubscribeEvent
    public void blockPlacedEvent(@Nonnull BlockEvent.PlaceEvent event) {
        WorldProvider provider = event.getWorld().field_73011_w;
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(provider.getDimension());
        if (!event.getWorld().field_72995_K && AtmosphereHandler.getOxygenHandler(provider.getDimension()) != null && atmhandler != null && !atmhandler.getAtmosphereType(event.getPos()).allowsCombustion()) {
            if (event.getPlacedBlock().func_177230_c() == Blocks.field_150478_aa) {
                EnumFacing direction = (EnumFacing)event.getPlacedBlock().func_177229_b((IProperty)BlockTorch.field_176596_a);
                event.getWorld().func_175656_a(event.getPos(), AdvancedRocketryBlocks.blockUnlitTorch.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)direction));
            } else if (ARConfiguration.getCurrentConfig().torchBlocks.contains(event.getPlacedBlock().func_177230_c())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void blockRightClicked(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        EnumFacing direction = event.getFace();
        WorldProvider provider = event.getWorld().field_73011_w;
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(provider.getDimension());
        if (!(event.getWorld().field_72995_K || direction == null || event.getEntityPlayer() == null || AtmosphereHandler.getOxygenHandler(provider.getDimension()) == null || atmhandler == null || atmhandler.getAtmosphereType(event.getPos().func_177972_a(direction)).allowsCombustion() || event.getEntityPlayer().func_184586_b(event.getHand()).func_190926_b() || event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() != Items.field_151033_d && event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() != Items.field_151059_bz && event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() != Items.field_151065_br && event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() != Items.field_151072_bj)) {
            event.setCanceled(true);
        }
        if (!event.getWorld().field_72995_K && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockGenericSeat) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150335_W) {
            ARAdvancements.BEER.trigger((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void disconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ARConfiguration.useClientDiskConfig();
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.getInstance().tickDimensions();
            ++time;
            if (!transitionMap.isEmpty()) {
                Iterator<TransitionEntity> itr = transitionMap.iterator();
                while (itr.hasNext()) {
                    TransitionEntity ent = itr.next();
                    if (ent.entity.field_70170_p.func_82737_E() < ent.time) continue;
                    ent.entity.func_70012_b((double)ent.location.func_177958_n(), (double)ent.location.func_177956_o(), (double)ent.location.func_177952_p(), ent.entity.field_70177_z, ent.entity.field_70125_A);
                    WorldServer newWorld = ent.entity.func_184102_h().func_71218_a(ent.dimId);
                    ent.entity.func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)ent.entity, ent.dimId, (Teleporter)new TeleporterNoPortal(newWorld));
                    Entity rocket = newWorld.func_175733_a(ent.entity2.getPersistentID());
                    if (rocket != null) {
                        ent.entity.func_184220_m(rocket);
                    }
                    itr.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.getInstance().tickDimensionsClient();
        }
    }

    @SubscribeEvent
    public void playerLoggedInEvent(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        int i;
        if (!event.isLocal()) {
            PacketHandler.sendToDispatcher((BasePacket)new PacketConfigSync(), (NetworkManager)event.getManager());
        }
        Object object = DimensionManager.getInstance().getStarIds().iterator();
        while (object.hasNext()) {
            i = object.next();
            PacketHandler.sendToDispatcher((BasePacket)new PacketStellarInfo(i, DimensionManager.getInstance().getStar(i)), (NetworkManager)event.getManager());
        }
        object = DimensionManager.getInstance().getRegisteredDimensions();
        i = ((Integer[])object).length;
        for (int j = 0; j < i; ++j) {
            int i2 = object[j];
            PacketHandler.sendToDispatcher((BasePacket)new PacketDimInfo(i2, DimensionManager.getInstance().getDimensionProperties(i2)), (NetworkManager)event.getManager());
        }
        for (ISpaceObject spaceObject : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
            PacketHandler.sendToDispatcher((BasePacket)new PacketSpaceStationInfo(spaceObject.getId(), spaceObject), (NetworkManager)event.getManager());
        }
        PacketHandler.sendToDispatcher((BasePacket)new PacketDimInfo(0, DimensionManager.getInstance().getDimensionProperties(0)), (NetworkManager)event.getManager());
    }

    public void connectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        DimensionManager.getInstance().unregisterAllDimensions();
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            AtmosphereHandler.registerWorld(event.getWorld().field_73011_w.getDimension());
        } else if (ARConfiguration.getCurrentConfig().skyOverride) {
            event.getWorld().field_73011_w.setSkyRenderer((IRenderHandler)new RenderPlanetarySky());
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            AtmosphereHandler.unregisterWorld(event.getWorld().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fogColor(EntityViewRenderEvent.FogColors event) {
        IBlockState state = ActiveRenderInfo.func_186703_a((World)event.getEntity().field_70170_p, (Entity)event.getEntity(), (float)((float)event.getRenderPartialTicks()));
        if (state.func_185904_a() == Material.field_151586_h) {
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(event.getEntity().field_71093_bK);
        if (properties != null) {
            if (event.getEntity().field_70170_p.field_73011_w instanceof IPlanetaryProvider) {
                Vec3d color = event.getEntity().field_70170_p.field_73011_w.func_76562_b(event.getEntity().field_70170_p.func_72826_c((float)event.getRenderPartialTicks()), (float)event.getRenderPartialTicks());
                event.setRed((float)Math.min(color.field_72450_a, 1.0));
                event.setGreen((float)Math.min(color.field_72448_b, 1.0));
                event.setBlue((float)Math.min(color.field_72449_c, 1.0));
                if (properties.getAtmosphereDensity() == 0) {
                    event.setRed(0.0f);
                    event.setGreen(0.0f);
                    event.setBlue(0.0f);
                }
            }
            if (endTime > 0L) {
                double amt = (double)(endTime - Minecraft.func_71410_x().field_71441_e.func_82737_E()) / (double)duration;
                if (amt < 0.0) {
                    endTime = 0L;
                } else {
                    event.setRed((float)amt);
                    event.setGreen((float)amt);
                    event.setBlue((float)amt);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleSourcePlacement(BlockEvent.CreateFluidSourceEvent event) {
        List<watersourcelocked> source_lock_list = DimensionManager.getInstance().getDimensionProperties((int)event.getWorld().field_73011_w.getDimension()).water_source_locked_positions;
        HashedBlockPosition hp = new HashedBlockPosition(event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
        for (watersourcelocked i : source_lock_list) {
            if (!i.pos.equals((Object)hp)) continue;
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.WorldTickEvent event) {
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        DimensionManager.getInstance().getDimensionProperties(event.getWorld().field_73011_w.getDimension()).add_chunk_to_terraforming_list(event.getChunk());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fogColor(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getFogMode() == -1) {
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(event.getEntity().field_71093_bK);
        if (properties != null && event.getState().func_177230_c() != Blocks.field_150355_j && event.getState().func_177230_c() != Blocks.field_150353_l) {
            float far;
            float near;
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            float f1 = event.getFarPlaneDistance();
            int atmosphere = Math.min(properties.getAtmosphereDensity(), 200);
            ItemStack armor = Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!armor.func_190926_b() && armor.func_77973_b() instanceof IModularArmor) {
                for (ItemStack i : ((IModularArmor)armor.func_77973_b()).getComponents(armor)) {
                    if (!i.func_77969_a(component)) continue;
                    atmosphere = Math.min(atmosphere, 100);
                    break;
                }
            }
            if (AtmosphereHandler.currentPressure != -1) {
                atmosphere = Math.min(AtmosphereHandler.currentPressure, 200);
            }
            if (atmosphere > 100) {
                near = 0.75f * f1 * (2.0f - (float)(atmosphere * atmosphere) / 10000.0f);
                far = f1;
            } else {
                near = 0.75f * f1 * (2.0f - (float)atmosphere / 100.0f);
                far = f1 * (2.002f - (float)atmosphere / 100.0f);
            }
            GlStateManager.func_179102_b((float)near);
            GlStateManager.func_179153_c((float)far);
            GlStateManager.func_179095_a((float)0.0f);
        }
    }

    @SubscribeEvent
    public void worldSaveEvent(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            try {
                DimensionManager.getInstance().saveDimensions("advRocketry");
            }
            catch (Exception e) {
                AdvancedRocketry.logger.fatal("An error has occurred saving planet data, this can happen if another mod causes the game to crash during game load.  If the game has fully loaded, then this is a serious error, Advanced Rocketry data has not been saved.");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void fallEvent(LivingFallEvent event) {
        if (event.getEntity().field_70170_p.field_73011_w instanceof IPlanetaryProvider) {
            IPlanetaryProvider planet = (IPlanetaryProvider)event.getEntity().field_70170_p.field_73011_w;
            event.setDistance((float)((double)event.getDistance() * planet.getGravitationalMultiplier(event.getEntity().func_180425_c())));
        }
    }

    static {
        transitionMap = new LinkedList<TransitionEntity>();
    }
}

