/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.client.SoundRocketEngine;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.mission.MissionGasCollection;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class EntityStationDeployedRocket
extends EntityRocket {
    public EnumFacing launchDirection;
    public EnumFacing forwardDirection;
    public HashedBlockPosition launchLocation;
    public Vec3d actualLaunchLocation;
    boolean coastMode;
    private ModuleText atmText;
    private short gasId;
    private ForgeChunkManager.Ticket ticket;

    public EntityStationDeployedRocket(World world) {
        super(world);
        this.launchDirection = EnumFacing.DOWN;
        this.launchLocation = new HashedBlockPosition(0, 0, 0);
        this.actualLaunchLocation = new Vec3d(0.0, 0.0, 0.0);
        this.atmText = new ModuleText(182, 114, "", 0x2D2D2D);
        this.gasId = 0;
        this.ticket = null;
    }

    public EntityStationDeployedRocket(World world, StorageChunk storage, StatsRocket stats, double x, double y, double z) {
        super(world, storage, stats, x, y, z);
        this.actualLaunchLocation = new Vec3d(x, y, z);
        this.launchLocation = new HashedBlockPosition((int)x, (int)y, (int)z);
        this.launchDirection = EnumFacing.DOWN;
        stats.setSeatLocation(Integer.MIN_VALUE, -1, -1);
        this.atmText = new ModuleText(182, 114, "", 0x2D2D2D);
        this.gasId = 0;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
    }

    @Override
    public void prepareLaunch() {
        RocketEvent.RocketPreLaunchEvent event = new RocketEvent.RocketPreLaunchEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (this.field_70170_p.field_72995_K) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.LAUNCH.ordinal()));
            }
            this.launch();
        }
    }

    @Override
    public void launch() {
        ISpaceObject spaceObj;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isInFlight()) {
            return;
        }
        if (this.isInOrbit()) {
            this.setInFlight(true);
            return;
        }
        if (this.getFuelAmount(this.getRocketFuelType()) < this.getFuelCapacity(this.getRocketFuelType())) {
            return;
        }
        if (this.field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_180425_c())) != null && spaceObj.getProperties().getParentProperties().isGasGiant()) {
            this.setInFlight(true);
            this.launchLocation.x = (int)Math.floor(this.field_70165_t);
            this.launchLocation.y = (short)this.field_70163_u;
            this.launchLocation.z = (int)Math.floor(this.field_70161_v);
            Iterator connectedTiles = this.connectedInfrastructure.iterator();
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
            while (connectedTiles.hasNext()) {
                IInfrastructure i = (IInfrastructure)connectedTiles.next();
                if (!i.disconnectOnLiftOff()) continue;
                this.disconnectInfrastructure(i);
                connectedTiles.remove();
            }
        }
    }

    @Override
    public void func_70071_h_() {
        this.lastWorldTickTicked = this.field_70170_p.func_82737_E();
        if (this.field_70173_aa == 20) {
            for (HashedBlockPosition temp : new LinkedList(this.infrastructureCoords)) {
                TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(temp.x, (int)temp.y, temp.z));
                if (!(tile instanceof IInfrastructure)) continue;
                this.linkInfrastructure((IInfrastructure)tile);
            }
            if (this.field_70170_p.field_72995_K) {
                LibVulpes.proxy.playSound((Object)new SoundRocketEngine(AudioRegistry.combustionRocket, SoundCategory.NEUTRAL, this));
            }
        }
        if (this.isInFlight()) {
            boolean isCoasting;
            boolean burningFuel = this.isBurningFuel();
            if (this.launchLocation == null || this.storage == null || this.actualLaunchLocation == null) {
                return;
            }
            if (!this.field_70170_p.field_72995_K && this.ticket == null) {
                this.ticket = ForgeChunkManager.requestTicket((Object)AdvancedRocketry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
                if (this.ticket != null) {
                    this.ticket.bindEntity((Entity)this);
                    for (int i = 0; i < 9; ++i) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)new ChunkPos(this.forwardDirection.func_82601_c() * i + (this.launchLocation.x >> 4), this.forwardDirection.func_82599_e() * i + (this.launchLocation.z >> 4)));
                    }
                }
            }
            boolean bl = isCoasting = Math.abs(this.field_70165_t - this.actualLaunchLocation.field_72450_a) < (double)(4 * this.storage.getSizeX()) && Math.abs(this.field_70163_u - this.actualLaunchLocation.field_72448_b) < (double)(4 * this.storage.getSizeY()) && Math.abs(this.field_70161_v - this.actualLaunchLocation.field_72449_c) < (double)(4 * this.storage.getSizeZ());
            if (!isCoasting && this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74362_aa < 2) {
                for (Vector3F vector3F : this.stats.getEngineLocations()) {
                    float xMult = this.forwardDirection.func_82601_c();
                    float zMult = this.forwardDirection.func_82599_e();
                    for (int i = 0; i < 4; ++i) {
                        float xVel = (1.0f - Math.abs(xMult)) * ((this.field_70146_Z.nextFloat() - 0.5f) / 8.0f) + xMult * -0.15f;
                        float zVel = (1.0f - Math.abs(zMult)) * ((this.field_70146_Z.nextFloat() - 0.5f) / 8.0f) + zMult * -0.15f;
                        double ox = 0.0;
                        double oz = 0.0;
                        double oy = 0.5;
                        if (this.isInOrbit()) {
                            AdvancedRocketry.proxy.spawnParticle("rocketFlame", this.field_70170_p, this.field_70165_t + (double)((Float)vector3F.x).floatValue() - (double)xMult + ox, this.field_70163_u + (double)((Float)vector3F.y).floatValue() + oy, this.field_70161_v + (double)((Float)vector3F.z).floatValue() - (double)zMult + oz, (double)xVel + (double)xMult * 0.5, (this.field_70146_Z.nextFloat() - 0.5f) / 8.0f, (double)zVel + (double)zMult * 0.5);
                            continue;
                        }
                        AdvancedRocketry.proxy.spawnParticle("rocketFlame", this.field_70170_p, this.field_70165_t + (double)((Float)vector3F.x).floatValue() - (double)xMult + ox, this.field_70163_u + (double)((Float)vector3F.y).floatValue() + oy, this.field_70161_v + (double)((Float)vector3F.z).floatValue() - (double)zMult + oz, xVel, (this.field_70146_Z.nextFloat() - 0.5f) / 8.0f, zVel);
                    }
                }
            }
            if (this.forwardDirection == null) {
                return;
            }
            if (this.isInOrbit()) {
                EnumFacing dir;
                boolean bl2 = isCoasting = Math.abs(this.field_70165_t - this.actualLaunchLocation.field_72450_a) < 0.01 && Math.abs(this.field_70161_v - this.actualLaunchLocation.field_72449_c) < 0.01;
                if (isCoasting) {
                    dir = this.launchDirection.func_176734_d();
                    float f = 0.02f;
                    this.field_70159_w = f * (float)dir.func_82601_c();
                    this.field_70181_x = f * (float)dir.func_96559_d();
                    this.field_70179_y = f * (float)dir.func_82599_e();
                } else {
                    dir = this.forwardDirection.func_176734_d();
                    float f = 0.005f;
                    this.field_70159_w = (double)f * (this.actualLaunchLocation.field_72450_a - this.field_70165_t) + 0.005 * (double)dir.func_82601_c();
                    this.field_70181_x = 0.0;
                    this.field_70179_y = (double)f * (this.actualLaunchLocation.field_72449_c - this.field_70161_v) + 0.005 * (double)dir.func_82599_e();
                }
                if (this.field_70163_u + 0.1 >= this.actualLaunchLocation.field_72448_b) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.setInFlight(false);
                        this.setInOrbit(false);
                        MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
                        if (this.ticket != null) {
                            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
                            this.ticket = null;
                        }
                    }
                    this.field_70181_x = 0.0;
                    this.func_70107_b(this.actualLaunchLocation.field_72450_a, this.actualLaunchLocation.field_72448_b, this.actualLaunchLocation.field_72449_c);
                }
            } else {
                if (isCoasting) {
                    float speed = 0.02f;
                    this.field_70159_w = (double)(speed * (float)this.launchDirection.func_82601_c()) * (2.1 * (double)this.storage.getSizeX() - Math.abs((double)(2 * this.storage.getSizeX()) - Math.abs(this.field_70165_t - this.actualLaunchLocation.field_72450_a)) + 0.05);
                    this.field_70181_x = (double)(speed * (float)this.launchDirection.func_96559_d()) * (2.1 * (double)this.storage.getSizeY() - Math.abs((double)(2 * this.storage.getSizeY()) - Math.abs(this.field_70163_u - this.actualLaunchLocation.field_72448_b)) + 0.05);
                    this.field_70179_y = (double)(speed * (float)this.launchDirection.func_82599_e()) * (2.1 * (double)this.storage.getSizeZ() - Math.abs((double)(2 * this.storage.getSizeZ()) - Math.abs(this.field_70161_v - this.actualLaunchLocation.field_72449_c)) + 0.05);
                } else {
                    float acc = 0.005f;
                    this.field_70159_w += (double)(acc * (float)this.forwardDirection.func_82601_c());
                    this.field_70181_x += (double)(acc * (float)this.forwardDirection.func_96559_d());
                    this.field_70179_y += (double)(acc * (float)this.forwardDirection.func_82599_e());
                    this.setFuelAmount(this.getRocketFuelType(), this.getFuelAmount(this.getRocketFuelType()) - 1);
                }
                if (!this.field_70170_p.field_72995_K && this.func_70011_f(this.actualLaunchLocation.field_72450_a, this.actualLaunchLocation.field_72448_b, this.actualLaunchLocation.field_72449_c) > 128.0) {
                    if (this.ticket != null) {
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
                        this.ticket = null;
                    }
                    this.onOrbitReached();
                    return;
                }
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        DimensionProperties props;
        List<ModuleBase> modules = super.getModules(ID, player);
        Iterator<ModuleBase> itr = modules.iterator();
        while (itr.hasNext()) {
            ModuleBase module = itr.next();
            if (!(module instanceof ModuleButton) || ((ModuleButton)module).buttonId != 1) continue;
            itr.remove();
            break;
        }
        if ((props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c())).isGasGiant()) {
            try {
                this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getLocalizedName(new FluidStack(props.getHarvestableGasses().get(this.gasId), 1)));
            }
            catch (IndexOutOfBoundsException e) {
                this.gasId = 0;
                this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getLocalizedName(new FluidStack(props.getHarvestableGasses().get(this.gasId), 1)));
            }
        } else {
            this.atmText.setText(LibVulpes.proxy.getLocalizedString("msg.entityDeployedRocket.notGasGiant"));
        }
        modules.add((ModuleBase)new ModuleButton(170, 114, 1, "", (IButtonInventory)this, TextureResources.buttonLeft, 5, 8));
        modules.add((ModuleBase)this.atmText);
        modules.add((ModuleBase)new ModuleButton(240, 114, 2, "", (IButtonInventory)this, TextureResources.buttonRight, 5, 8));
        return modules;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.DECONSTRUCT.ordinal()));
                break;
            }
            case 1: {
                DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
                if (!props.isGasGiant()) break;
                this.gasId = (short)(this.gasId + 1);
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()));
                break;
            }
            case 2: {
                DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
                if (!props.isGasGiant()) break;
                this.gasId = (short)(this.gasId - 1);
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()));
                break;
            }
            default: {
                super.onInventoryButtonPressed(buttonId);
            }
        }
    }

    @Override
    public void onOrbitReached() {
        ISpaceObject spaceObj;
        if (this.field_70170_p.field_72995_K) {
            System.out.println("this code should not run on client side!");
        }
        if (this.field_70128_L) {
            return;
        }
        this.setInOrbit(true);
        if (this.field_70170_p.field_73011_w.getDimension() != ARConfiguration.getCurrentConfig().spaceDimId || (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_180425_c())) == null || !spaceObj.getProperties().getParentProperties().isGasGiant()) {
            this.setInOrbit(true);
            return;
        }
        this.func_70107_b((double)this.forwardDirection.func_82601_c() * 64.0 + this.actualLaunchLocation.field_72450_a, this.field_70163_u, (double)this.forwardDirection.func_82599_e() * 64.0 + this.actualLaunchLocation.field_72449_c);
        DimensionProperties properties = (DimensionProperties)spaceObj.getProperties().getParentProperties();
        if (this.gasId >= properties.getHarvestableGasses().size() || this.gasId < 0) {
            this.setInOrbit(true);
            return;
        }
        float intakePower = ((Integer)this.stats.getStatTag("intakePower")).intValue();
        MissionGasCollection miningMission = new MissionGasCollection(intakePower == 0.0f ? 360L : (long)(2.0f * ((float)((Integer)this.stats.getStatTag("liquidCapacity")).intValue() / intakePower)), this, this.connectedInfrastructure, properties.getHarvestableGasses().get(this.gasId));
        miningMission.setDimensionId(properties.getId());
        properties.addSatellite(miningMission);
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(miningMission));
        }
        for (IInfrastructure i : this.connectedInfrastructure) {
            i.linkMission(miningMission);
        }
        this.func_70106_y();
    }

    @Override
    protected void writeNetworkableNBT(NBTTagCompound nbt) {
        super.writeNetworkableNBT(nbt);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            out.writeShort((int)this.gasId);
        } else {
            super.writeDataToNetwork(out, id);
        }
    }

    @Override
    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            nbt.func_74777_a("gas", in.readShort());
        } else {
            super.readDataFromNetwork(in, packetId, nbt);
        }
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
            if (props.isGasGiant()) {
                this.gasId = nbt.func_74765_d("gas");
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                if (!this.field_70170_p.field_72995_K) {
                    PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()), (int)this.field_70170_p.field_73011_w.getDimension(), (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (double)64.0);
                } else {
                    this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getLocalizedName(new FluidStack(props.getHarvestableGasses().get(this.gasId), 1)));
                }
            }
        } else {
            super.useNetworkData(player, side, id, nbt);
        }
    }

    @Override
    public void writeMissionPersistentNBT(NBTTagCompound nbt) {
        super.writeMissionPersistentNBT(nbt);
        nbt.func_74768_a("fwd", this.forwardDirection.ordinal());
        nbt.func_74768_a("launchX", this.launchLocation.x);
        nbt.func_74768_a("launchY", (int)this.launchLocation.y);
        nbt.func_74768_a("launchZ", this.launchLocation.z);
        nbt.func_74780_a("AlaunchX", this.actualLaunchLocation.field_72450_a);
        nbt.func_74780_a("AlaunchY", this.actualLaunchLocation.field_72448_b);
        nbt.func_74780_a("AlaunchZ", this.actualLaunchLocation.field_72449_c);
        nbt.func_74777_a("gas", this.gasId);
    }

    @Override
    public void readMissionPersistentNBT(NBTTagCompound nbt) {
        super.readMissionPersistentNBT(nbt);
        this.forwardDirection = EnumFacing.values()[nbt.func_74762_e("fwd")];
        this.launchLocation.x = nbt.func_74762_e("launchX");
        this.launchLocation.y = (short)nbt.func_74762_e("launchY");
        this.launchLocation.z = nbt.func_74762_e("launchZ");
        double ax = nbt.func_74769_h("AlaunchX");
        double ay = nbt.func_74769_h("AlaunchY");
        double az = nbt.func_74769_h("AlaunchZ");
        this.actualLaunchLocation = new Vec3d(ax, ay, az);
        this.gasId = nbt.func_74765_d("gas");
    }
}

