/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.tile.multiblock.TileSpaceElevator;
import zmaster587.advancedRocketry.util.DimensionBlockPosition;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class EntityElevatorCapsule
extends Entity
implements INetworkEntity {
    public static final double MAX_HEIGHT = ARConfiguration.getCurrentConfig().orbit;
    public static final double MAX_STANDTIME = 200.0;
    protected static final DataParameter<Byte> motionDir = EntityDataManager.func_187226_a(EntityElevatorCapsule.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> standTimeCounter = EntityDataManager.func_187226_a(EntityElevatorCapsule.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final byte PACKET_WRITE_DST_INFO = 0;
    private static final byte PACKET_RECIEVE_NBT = 1;
    private static final byte PACKET_LAUNCH_EVENT = 2;
    private static final byte PACKET_DEORBIT = 3;
    private static final byte PACKET_WRITE_SRC_INFO = 4;
    byte motion;
    int standTime;
    int idleTime;
    DimensionBlockPosition dstTilePos;
    DimensionBlockPosition srcTilePos;

    public EntityElevatorCapsule(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 3.0f);
        this.motion = 0;
        this.field_70158_ak = true;
    }

    public boolean isAscending() {
        return (Byte)this.field_70180_af.func_187225_a(motionDir) > 0;
    }

    public boolean isDescending() {
        return (Byte)this.field_70180_af.func_187225_a(motionDir) < 0;
    }

    public boolean isInMotion() {
        return (Byte)this.field_70180_af.func_187225_a(motionDir) != 0;
    }

    public void setCapsuleMotion(int motion) {
        this.field_70180_af.func_187227_b(motionDir, (Object)((byte)motion));
        this.motion = (byte)motion;
    }

    public int getStandTime() {
        this.standTime = (Integer)this.field_70180_af.func_187225_a(standTimeCounter);
        return this.standTime;
    }

    public void setStandTime(int time) {
        this.field_70180_af.func_187227_b(standTimeCounter, (Object)this.standTime);
    }

    public int decrStandTime() {
        this.standTime = this.getStandTime() - 1;
        this.field_70180_af.func_187227_b(standTimeCounter, (Object)this.standTime);
        return this.standTime;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(motionDir, (Object)this.motion);
        this.field_70180_af.func_187214_a(standTimeCounter, (Object)this.standTime);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        int[] loc;
        this.setCapsuleMotion(nbt.func_74771_c("motionDir"));
        if (nbt.func_74764_b("dstDimid")) {
            this.dstTilePos = new DimensionBlockPosition(-2147483647, null);
            this.dstTilePos.dimid = nbt.func_74762_e("dstDimid");
            loc = nbt.func_74759_k("dstLoc");
            this.dstTilePos.pos = new HashedBlockPosition(loc[0], loc[1], loc[2]);
        } else {
            this.dstTilePos = null;
        }
        if (nbt.func_74764_b("srcDimid")) {
            this.srcTilePos = new DimensionBlockPosition(-2147483647, null);
            this.srcTilePos.dimid = nbt.func_74762_e("srcDimid");
            loc = nbt.func_74759_k("srcLoc");
            this.srcTilePos.pos = new HashedBlockPosition(loc[0], loc[1], loc[2]);
        } else {
            this.srcTilePos = null;
        }
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        if (this.field_70170_p.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, 1));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("motionDir", this.motion);
        if (this.dstTilePos != null) {
            nbt.func_74768_a("dstDimid", this.dstTilePos.dimid);
            nbt.func_74783_a("dstLoc", new int[]{this.dstTilePos.pos.x, this.dstTilePos.pos.y, this.dstTilePos.pos.z});
        }
        if (this.srcTilePos != null) {
            nbt.func_74768_a("srcDimid", this.srcTilePos.dimid);
            nbt.func_74783_a("srcLoc", new int[]{this.srcTilePos.pos.x, this.srcTilePos.pos.y, this.srcTilePos.pos.z});
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void setDst(DimensionBlockPosition location) {
        this.dstTilePos = location;
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 0), (Entity)this);
        }
    }

    public void setSourceTile(DimensionBlockPosition location) {
        this.srcTilePos = location;
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 4), (Entity)this);
        }
    }

    public Entity func_184204_a(int newDimId) {
        return this.changeDimension(newDimId, this.field_70165_t, ARConfiguration.getCurrentConfig().orbit, this.field_70161_v);
    }

    public void func_180432_n(Entity entityIn) {
        NBTTagCompound nbttagcompound = entityIn.func_189511_e(new NBTTagCompound());
        nbttagcompound.func_82580_o("Dimension");
        nbttagcompound.func_82580_o("Passengers");
        this.func_70020_e(nbttagcompound);
        this.field_71088_bW = entityIn.field_71088_bW;
    }

    @Nullable
    public Entity changeDimension(int dimensionIn, double posX, double y, double posZ) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            float yaw = this.field_70177_z;
            float pitch = this.field_70125_A;
            DimensionBlockPosition destination = this.dstTilePos;
            List passengers = this.func_184188_bt();
            int i = this.field_71093_bK;
            MinecraftServer minecraftserver = this.func_184102_h();
            WorldServer worldserver = minecraftserver.func_71218_a(i);
            WorldServer worldserver1 = minecraftserver.func_71218_a(dimensionIn);
            this.func_70107_b(posX, y, posZ);
            TeleporterNoPortal teleporter = new TeleporterNoPortal(worldserver1);
            Entity entity = this.changeDimension(dimensionIn, (ITeleporter)teleporter);
            if (entity == null) {
                return null;
            }
            entity.func_70080_a(posX, y, posZ, yaw, pitch);
            ((EntityElevatorCapsule)entity).dstTilePos = destination;
            int timeOffset = 1;
            for (Entity e : passengers) {
                PlanetEventHandler.addDelayedTransition(new TransitionEntity(worldserver.func_82737_E() + (long)(++timeOffset), e, dimensionIn, new BlockPos(posX, y, posZ), entity));
            }
            return entity;
        }
        return null;
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(this.field_70165_t, 2000.0, this.field_70161_v);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 5) {
            if (this.dstTilePos != null) {
                this.setDst(this.dstTilePos);
            }
            if (this.srcTilePos != null) {
                this.setSourceTile(this.srcTilePos);
            }
        }
        if (this.isAscending()) {
            this.field_70181_x = this.field_70163_u > 255.0 ? 5.85 : 1.85;
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ());
                for (Entity ent : list) {
                    if (this.func_184187_bx() != null) continue;
                    ent.func_184220_m((Entity)this);
                }
                if (this.field_70163_u > MAX_HEIGHT) {
                    double landingLocZ;
                    double landingLocX;
                    TileEntity tile;
                    this.setCapsuleMotion(1);
                    WorldServer world = DimensionManager.getWorld((int)this.dstTilePos.dimid);
                    if (world == null) {
                        DimensionManager.initDimension((int)this.dstTilePos.dimid);
                        world = DimensionManager.getWorld((int)this.dstTilePos.dimid);
                    }
                    if (world != null) {
                        tile = world.func_175625_s(this.dstTilePos.pos.getBlockPos());
                        if (!(tile instanceof TileSpaceElevator)) {
                            this.func_70106_y();
                            return;
                        }
                        landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                        landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                    } else {
                        this.dstTilePos = this.srcTilePos;
                        world = this.func_130014_f_();
                        tile = world.func_175625_s(this.dstTilePos.pos.getBlockPos());
                        if (!(tile instanceof TileSpaceElevator)) {
                            this.func_70106_y();
                            return;
                        }
                        landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                        landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                    }
                    this.changeDimension(this.dstTilePos.dimid, landingLocX, 10.0, landingLocZ);
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
                }
            }
            if (this.dstTilePos != null && this.dstTilePos.pos != null && this.field_70163_u >= (double)(this.dstTilePos.pos.y - 4) && this.field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId) {
                this.setCapsuleMotion(0);
                this.func_70107_b(this.dstTilePos.pos.x, this.dstTilePos.pos.y - 5, this.dstTilePos.pos.z);
                TileEntity e = this.field_70170_p.func_175625_s(this.dstTilePos.pos.getBlockPos());
                if (e instanceof TileSpaceElevator) {
                    ((TileSpaceElevator)e).notifyLanded(this);
                    this.standTime = 0;
                } else {
                    this.func_70106_y();
                }
                for (Entity ent : this.func_184188_bt()) {
                    ent.func_184210_p();
                }
            }
            this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
            return;
        }
        if (this.isDescending()) {
            this.field_70122_E = false;
            this.field_70181_x = this.field_70163_u > 255.0 ? -5.85 : -1.85;
            if (this.field_70170_p.field_72995_K) {
                this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
                return;
            }
            if (this.field_70173_aa == 20) {
                PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 3), (Entity)this);
            }
            List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ());
            for (Object ent : list) {
                if (this.func_184187_bx() == null) {
                    ent.func_184220_m((Entity)this);
                }
                ((Entity)ent).field_70143_R = 0.0f;
            }
            this.field_70143_R = 0.0f;
            if (this.field_70163_u <= (double)(this.dstTilePos.pos.y + 1) && this.field_70170_p.field_73011_w.getDimension() != ARConfiguration.getCurrentConfig().spaceDimId) {
                Object ent;
                this.setCapsuleMotion(0);
                this.func_70107_b(this.dstTilePos.pos.x, this.dstTilePos.pos.y + 1, this.dstTilePos.pos.z);
                TileEntity e = this.field_70170_p.func_175625_s(this.dstTilePos.pos.getBlockPos());
                if (e instanceof TileSpaceElevator) {
                    ((TileSpaceElevator)e).notifyLanded(this);
                    this.standTime = 0;
                } else {
                    this.func_70106_y();
                }
                ent = this.func_184188_bt().iterator();
                while (ent.hasNext()) {
                    Entity ent2 = (Entity)ent.next();
                    ent2.func_184210_p();
                }
                return;
            }
            if (this.field_70163_u <= 15.0 && this.field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId) {
                double landingLocZ;
                double landingLocX;
                this.setCapsuleMotion(-1);
                WorldServer world = DimensionManager.getWorld((int)this.dstTilePos.dimid);
                if (world == null) {
                    DimensionManager.initDimension((int)this.dstTilePos.dimid);
                    world = DimensionManager.getWorld((int)this.dstTilePos.dimid);
                }
                if (world != null) {
                    TileEntity tile = world.func_175625_s(this.dstTilePos.pos.getBlockPos());
                    if (!(tile instanceof TileSpaceElevator)) {
                        this.func_70106_y();
                        return;
                    }
                    landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                    landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                } else {
                    this.dstTilePos = this.srcTilePos;
                    world = this.func_130014_f_();
                    TileEntity tile = world.func_175625_s(this.dstTilePos.pos.getBlockPos());
                    if (!(tile instanceof TileSpaceElevator)) {
                        this.func_70106_y();
                        return;
                    }
                    landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                    landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                }
                this.changeDimension(this.dstTilePos.dimid, landingLocX, ARConfiguration.getCurrentConfig().orbit, landingLocZ);
                MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
                return;
            }
            this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
            return;
        }
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ());
        if (!this.field_70170_p.field_72995_K) {
            TileEntity srcTile = null;
            if (list.isEmpty()) {
                this.standTime = 0;
            } else if (this.dstTilePos != null && TileSpaceElevator.isDestinationValid(this.dstTilePos.dimid, this.dstTilePos, new HashedBlockPosition(this.func_180425_c()), this.field_70170_p.field_73011_w.getDimension())) {
                ++this.standTime;
            }
            if (this.srcTilePos != null && this.srcTilePos.pos != null) {
                srcTile = this.field_70170_p.func_175625_s(this.srcTilePos.pos.getBlockPos());
            }
            if (srcTile instanceof TileSpaceElevator && !((TileSpaceElevator)srcTile).getMachineEnabled()) {
                this.standTime = 0;
            }
            this.setStandTime(this.standTime);
            if (!((double)this.standTime > 200.0)) return;
            if (this.srcTilePos == null) return;
            if (this.srcTilePos.pos == null) return;
            srcTile = this.field_70170_p.func_175625_s(this.srcTilePos.pos.getBlockPos());
            if (!(srcTile instanceof TileSpaceElevator)) return;
            if (!((TileSpaceElevator)srcTile).attemptLaunch()) return;
            if (this.field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId) {
                this.setCapsuleMotion(-1);
            } else {
                this.setCapsuleMotion(1);
            }
            List list2 = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ());
            Iterator iterator = list2.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
                    PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 2), (Entity)this);
                    return;
                }
                Entity ent = (Entity)iterator.next();
                if (this.func_184187_bx() != null) continue;
                ent.func_184220_m((Entity)this);
            }
        }
        if (list.isEmpty()) return;
        TileEntity srcTile = null;
        if (this.srcTilePos != null && this.srcTilePos.pos != null) {
            srcTile = this.field_70170_p.func_175625_s(this.srcTilePos.pos.getBlockPos());
        }
        if (srcTile instanceof TileSpaceElevator && !((TileSpaceElevator)srcTile).getMachineEnabled()) {
            AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.spaceElevator.turnedOff"), 5);
            return;
        }
        if (this.dstTilePos != null) {
            AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.spaceElevator.ascentReady") + ": " + (int)((200.0 - (double)this.getStandTime()) / 20.0) + "\nDST " + this.dstTilePos, 5);
            return;
        }
        AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.label.noneSelected"), 5);
    }

    public double func_70042_X() {
        return 0.3;
    }

    public AxisAlignedBB func_70046_E() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, this.func_174813_aQ().field_72338_b, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, this.func_174813_aQ().field_72337_e - 3.0, this.func_174813_aQ().field_72334_f);
        return this.isAscending() || this.isDescending() ? null : aabb;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        return par1 < 1.6777216E7;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeBoolean(this.dstTilePos != null);
            if (this.dstTilePos != null) {
                out.writeInt(this.dstTilePos.dimid);
                out.writeInt(this.dstTilePos.pos.x);
                out.writeInt((int)this.dstTilePos.pos.y);
                out.writeInt(this.dstTilePos.pos.z);
            }
        } else if (id == 4) {
            out.writeBoolean(this.dstTilePos != null);
            if (this.srcTilePos != null) {
                out.writeInt(this.srcTilePos.dimid);
                out.writeInt(this.srcTilePos.pos.x);
                out.writeInt((int)this.srcTilePos.pos.y);
                out.writeInt(this.srcTilePos.pos.z);
            }
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if ((packetId == 0 || packetId == 4) && in.readBoolean()) {
            nbt.func_74768_a("dimid", in.readInt());
            nbt.func_74768_a("x", in.readInt());
            nbt.func_74768_a("y", in.readInt());
            nbt.func_74768_a("z", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0 && this.field_70170_p.field_72995_K) {
            this.dstTilePos = nbt.func_74764_b("dimid") ? new DimensionBlockPosition(nbt.func_74762_e("dimid"), new HashedBlockPosition(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))) : null;
        } else if (id == 4 && this.field_70170_p.field_72995_K) {
            this.srcTilePos = nbt.func_74764_b("dimid") ? new DimensionBlockPosition(nbt.func_74762_e("dimid"), new HashedBlockPosition(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))) : null;
        } else if (id == 1) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 0), (Entity)this);
        } else if (id == 2 && this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ());
            for (Entity ent : list) {
                if (this.func_184187_bx() != null) continue;
                ent.func_184220_m((Entity)this);
            }
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
        } else if (id == 3 && this.field_70170_p.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
        }
    }
}

