/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.planet;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.Vector3F;

public class RenderSpaceSky
extends RenderPlanetarySky {
    Minecraft mc = Minecraft.func_71410_x();

    @Override
    protected void drawStar(BufferBuilder buffer, StellarBody sun, DimensionProperties properties, int solarOrbitalDistance, float sunSize, Vec3d sunColor, float multiplier) {
        DimensionProperties parentProperties = properties.getParentProperties();
        if (parentProperties != null && sun != parentProperties.getStarData()) {
            super.drawStar(buffer, sun, properties, solarOrbitalDistance, sunSize, sunColor, multiplier);
        }
    }

    @Override
    public void renderPlanet2(BufferBuilder buffer, DimensionProperties properties, float size, float alphaMultiplier, double shadowAngle, boolean hasRing, float[] shadowColorMultiplier, float alphaMultiplier2) {
        float f15;
        int clientRenderDistanceBlocks = this.mc.field_71474_y.field_151451_c * 16;
        ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.mc.field_71439_g.func_180425_c());
        if (spaceObject == null) {
            return;
        }
        float planetOrbitalDistance = spaceObject.getOrbitalDistance();
        if (properties.isStar()) {
            planetOrbitalDistance = 190.0f;
            double tr_y = 100.0;
            size = 10.0f;
            float ro = -20.0f;
            if (properties.getStar().isBlackHole()) {
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3008);
                GL11.glAlphaFunc((int)516, (float)0.01f);
                GL11.glDisable((int)3042);
                GL11.glPushMatrix();
                GL11.glRotatef((float)140.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)((float)tr_y), (float)0.0f);
                GL11.glPushMatrix();
                float f10 = size * 2.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179129_p();
                this.renderSphere(0.0, 0.0, 0.0, f10, 32, 23);
                GlStateManager.func_179089_o();
                GL11.glEnable((int)3042);
                GL11.glDepthMask((boolean)false);
                GL11.glPopMatrix();
                this.mc.field_71446_o.func_110577_a(TextureResources.locationAccretionDiskDense);
                GlStateManager.func_179132_a((boolean)false);
                float speedMult = 5.0f;
                GlStateManager.func_179129_p();
                GL11.glPushMatrix();
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(129600.0f * speedMult))) / (360.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)0.7f, (float)0.5f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = size * 7.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
                for (int i = 0; i < 1; ++i) {
                    speedMult = (float)i * 1.05f + 5.0f;
                    this.mc.field_71446_o.func_110577_a(TextureResources.locationAccretionDisk);
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)(60.0f + ro), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(129600.0f * speedMult))) / (360.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    f10 = size * 40.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                    buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                    Tessellator.func_178181_a().func_78381_a();
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
                    GL11.glRotatef((float)(60.0f + ro), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(72000.0f * speedMult))) / (200.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179131_c((float)0.8f, (float)0.7f, (float)0.4f, (float)1.0f);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    f10 = size * 30.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                    buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                    Tessellator.func_178181_a().func_78381_a();
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
                    GL11.glRotatef((float)(60.0f + ro), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(36000.0f * speedMult))) / (100.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179131_c((float)0.2f, (float)0.4f, (float)1.0f, (float)1.0f);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    f10 = size * 15.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                    buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                    buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                    Tessellator.func_178181_a().func_78381_a();
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
            } else {
                this.mc.field_71446_o.func_110577_a(TextureResources.locationSunPng);
                GlStateManager.func_179131_c((float)properties.getStar().getColor()[0], (float)properties.getStar().getColor()[1], (float)properties.getStar().getColor()[2], (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                float f10 = properties.getStar().getSize() * 15.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                GL11.glPushMatrix();
                GL11.glRotatef((float)60.0f, (float)-60.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
            }
            GlStateManager.func_179132_a((boolean)true);
            GL11.glClear((int)256);
            GlStateManager.func_179132_a((boolean)false);
            return;
        }
        if (Objects.equals(properties.customIcon, "void")) {
            return;
        }
        float[] atmColor = properties.skyColor;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GlStateManager.func_179106_n();
        GlStateManager.func_179112_b((int)1, (int)0);
        this.mc.field_71446_o.func_110577_a(this.getTextureForPlanet(properties));
        GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        float f10 = 100.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
        float Xoffset = (float)((double)System.currentTimeMillis() / 1000000.0 % 1.0);
        float f14 = 1.0f + Xoffset;
        float f16 = f15 = 0.0f + Xoffset;
        float f17 = f14;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
        double yo = -10.0;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(-f10), yo, (double)f10).func_187315_a((double)f16, (double)f17).func_181675_d();
        buffer.func_181662_b((double)f10, yo, (double)f10).func_187315_a((double)f14, (double)f17).func_181675_d();
        buffer.func_181662_b((double)f10, yo, (double)(-f10)).func_187315_a((double)f14, (double)f15).func_181675_d();
        buffer.func_181662_b((double)(-f10), yo, (double)(-f10)).func_187315_a((double)f16, (double)f15).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopAttrib();
        if (properties.hasDecorators()) {
            if (properties.isGasGiant()) {
                int i;
                GlStateManager.func_179112_b((int)770, (int)1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                this.mc.field_71446_o.func_110577_a(DimensionProperties.getAtmosphereLEOResource());
                GlStateManager.func_179131_c((float)atmColor[0], (float)atmColor[1], (float)atmColor[2], (float)0.5f);
                double dist = -5.0 - (double)(4.0f * planetOrbitalDistance) / 200.0;
                double scalingMult = 1.0 - 0.9 * (double)planetOrbitalDistance / 200.0;
                int maxAmt = 6;
                float lng = (float)((double)Minecraft.func_71386_F() / 100000.0 % 1.0);
                for (i = 0; i < maxAmt; ++i) {
                    Xoffset = lng * ((float)i - (float)maxAmt / 4.0f);
                    float Yoffset = -lng * (float)i;
                    f14 = (float)i + Yoffset;
                    f15 = 0.0f + Yoffset;
                    f16 = 0.0f + Xoffset;
                    f17 = (float)i + Xoffset;
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(yo + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(yo + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(yo + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(yo + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179090_x();
                GlStateManager.func_179112_b((int)770, (int)771);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                GlStateManager.func_179131_c((float)atmColor[0], (float)atmColor[1], (float)atmColor[2], (float)0.08f);
                for (i = 0; i < 5; ++i) {
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179098_w();
            } else if (properties.hasAtmosphere()) {
                GlStateManager.func_179112_b((int)770, (int)1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                this.mc.field_71446_o.func_110577_a(DimensionProperties.getAtmosphereLEOResource());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                Xoffset = (float)((double)System.currentTimeMillis() / 100000.0 % 1.0);
                f14 = 1.0f + Xoffset;
                f16 = f15 = 0.0f + Xoffset;
                f17 = f14;
                RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)yo, (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)yo, (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)yo, (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)yo, (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179090_x();
                GlStateManager.func_179112_b((int)770, (int)771);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                GlStateManager.func_179131_c((float)atmColor[0], (float)atmColor[1], (float)atmColor[2], (float)0.08f);
                double dist = -5.0 - (double)(4.0f * planetOrbitalDistance) / 200.0;
                double scalingMult = 1.0 - 0.9 * (double)planetOrbitalDistance / 200.0;
                for (int i = 0; i < 5; ++i) {
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                    RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179098_w();
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179127_m();
        GL11.glPopMatrix();
    }

    @Override
    protected EnumFacing getRotationAxis(DimensionProperties properties, BlockPos pos) {
        try {
            return SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos).getForwardDirection().func_176746_e();
        }
        catch (Exception e) {
            return EnumFacing.EAST;
        }
    }

    @Override
    protected void rotateAroundAxis() {
        Vector3F<Float> axis = this.getRotateAxis();
        ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.mc.field_71439_g.func_180425_c());
        if (spaceObject != null) {
            GL11.glRotated((double)(spaceObject.getRotation(EnumFacing.UP) * 360.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(spaceObject.getRotation(EnumFacing.EAST) * 360.0), (double)1.0, (double)0.0, (double)0.0);
        }
    }

    @Override
    protected ResourceLocation getTextureForPlanet(DimensionProperties properties) {
        return properties.getPlanetIconLEO();
    }
}

