/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.planet;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.libVulpes.util.Vector3F;

public class RenderAsteroidSky
extends IRenderHandler {
    public static final ResourceLocation asteroid1 = new ResourceLocation("advancedRocketry:textures/planets/asteroid_a.png");
    public static final ResourceLocation asteroid2 = new ResourceLocation("advancedRocketry:textures/planets/asteroid_b.png");
    public static final ResourceLocation asteroid3 = new ResourceLocation("advancedRocketry:textures/planets/asteroid_c.png");
    ResourceLocation currentlyBoundTex = null;
    float celestialAngle;
    Vector3F<Float> axis;
    Minecraft mc = Minecraft.func_71410_x();
    private int starGLCallList;
    private int glSkyList;
    private int glSkyList2;
    private int glSkyList3;
    private static float xrotangle = 0.0f;
    private static float[] skycolor = new float[]{0.0f, 0.0f, 0.0f};
    private static double currentplanetphi = 0.0;

    public RenderAsteroidSky() {
        int k;
        int j;
        this.axis = new Vector3F((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        this.starGLCallList = GLAllocation.func_74526_a((int)4);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int b2 = 64;
        int i = 256 / b2 + 2;
        float f = 16.0f;
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                buffer.func_181662_b((double)j, (double)f, (double)k).func_181675_d();
                buffer.func_181662_b((double)(j + b2), (double)f, (double)k).func_181675_d();
                buffer.func_181662_b((double)(j + b2), (double)f, (double)(k + b2)).func_181675_d();
                buffer.func_181662_b((double)j, (double)f, (double)(k + b2)).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                buffer.func_181662_b((double)j, (double)f, (double)k).func_181675_d();
                buffer.func_181662_b((double)(j + b2), (double)f, (double)k).func_181675_d();
                buffer.func_181662_b((double)(j + b2), (double)f, (double)(k + b2)).func_181675_d();
                buffer.func_181662_b((double)j, (double)f, (double)(k + b2)).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEndList();
        this.glSkyList3 = this.starGLCallList + 3;
        GL11.glPushMatrix();
        GL11.glNewList((int)this.glSkyList3, (int)4864);
        this.renderAsteroids();
        GL11.glEndList();
        GL11.glPopMatrix();
    }

    private void renderAsteroids() {
        Random random = new Random(10843L);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (int i = 0; i < 200; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() - 0.5f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double size = 0.15f + random.nextFloat();
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 0.5 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            float r = random.nextFloat() * 0.05f + 0.95f;
            float g = random.nextFloat() * 0.1f + 0.9f;
            float b = random.nextFloat() * 0.1f + 0.9f;
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * size;
                double d19 = (double)((j + 1 & 2) - 1) * size;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                buffer.func_181662_b(d5 + d24, d6 + d22, d7 + d25).func_187315_a(d18 / (size * 2.0) + 0.5, d19 / (size * 2.0) + 0.5).func_181666_a(r, g, b, 1.0f).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void renderStars() {
        Random random = new Random(10842L);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 2000; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                buffer.func_181662_b(d5 + d24, d6 + d22, d7 + d25).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float f10;
        float f9;
        float f8;
        float f7;
        int atmosphereInt;
        float f6;
        SpaceStationObject station;
        StellarBody primaryStar;
        Vec3d sunColor;
        boolean isMoon;
        int solarOrbitalDistance;
        LinkedList<DimensionProperties> children;
        float atmosphere;
        DimensionProperties properties;
        int planetOrbitalDistance = 0;
        double myPhi = 0.0;
        double myTheta = 0.0;
        double myPrevOrbitalTheta = 0.0;
        double myRotationalPhi = 0.0;
        boolean hasAtmosphere = false;
        float[] shadowColorMultiplier = new float[]{0.0f, 0.0f, 0.0f};
        float[] parentAtmColor = new float[]{1.0f, 1.0f, 1.0f};
        float[] parentRingColor = new float[]{1.0f, 1.0f, 1.0f};
        float[] ringColor = new float[]{1.0f, 1.0f, 1.0f};
        float sunSize = 1.0f;
        float starSeparation = 0.0f;
        boolean isWarp = false;
        boolean isGasGiant = false;
        boolean hasRings = false;
        boolean parentPlanetHasDecorator = true;
        boolean parentHasRings = false;
        boolean parentHasATM = false;
        DimensionProperties parentProperties = null;
        EnumFacing travelDirection = null;
        Object parentPlanetIcon = null;
        this.celestialAngle = mc.field_71441_e.func_72826_c(partialTicks);
        if (mc.field_71441_e.field_73011_w instanceof IPlanetaryProvider) {
            IPlanetaryProvider planetaryProvider = (IPlanetaryProvider)mc.field_71441_e.field_73011_w;
            properties = (DimensionProperties)planetaryProvider.getDimensionProperties(mc.field_71439_g.func_180425_c());
            atmosphere = planetaryProvider.getAtmosphereDensityFromHeight(mc.func_175606_aa().field_70163_u, mc.field_71439_g.func_180425_c());
            EnumFacing dir = this.getRotationAxis(properties, mc.field_71439_g.func_180425_c());
            this.axis.x = Float.valueOf(dir.func_82601_c());
            this.axis.y = Float.valueOf(dir.func_96559_d());
            this.axis.z = Float.valueOf(dir.func_82599_e());
            myPhi = properties.orbitalPhi;
            myTheta = properties.orbitTheta;
            myRotationalPhi = properties.rotationalPhi;
            myPrevOrbitalTheta = properties.prevOrbitalTheta;
            hasRings = properties.hasRings();
            ringColor = properties.ringColor;
            children = new LinkedList();
            for (Integer i : properties.getChildPlanets()) {
                children.add(DimensionManager.getInstance().getDimensionProperties(i));
            }
            solarOrbitalDistance = properties.getSolarOrbitalDistance();
            isMoon = properties.isMoon();
            if (isMoon) {
                parentProperties = properties.getParentProperties();
                planetOrbitalDistance = properties.getParentOrbitalDistance();
                parentHasRings = parentProperties.hasRings;
                parentRingColor = parentProperties.ringColor;
            }
            sunColor = planetaryProvider.getSunColor(mc.field_71439_g.func_180425_c());
            primaryStar = properties.getStar();
            if (primaryStar != null) {
                sunSize = properties.getStar().getSize();
            } else {
                primaryStar = DimensionManager.getInstance().getStar(0);
            }
            if (world.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId) {
                boolean bl = isWarp = properties.getParentPlanet() == Integer.MIN_VALUE;
                if (isWarp) {
                    station = (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(mc.field_71439_g.func_180425_c());
                    travelDirection = station.getForwardDirection();
                }
            }
        } else if (DimensionManager.getInstance().isDimensionCreated(mc.field_71441_e.field_73011_w.getDimension())) {
            properties = DimensionManager.getInstance().getDimensionProperties(mc.field_71441_e.field_73011_w.getDimension());
            atmosphere = properties.getAtmosphereDensityAtHeight(mc.func_175606_aa().field_70163_u);
            EnumFacing dir = this.getRotationAxis(properties, mc.field_71439_g.func_180425_c());
            this.axis.x = Float.valueOf(dir.func_82601_c());
            this.axis.y = Float.valueOf(dir.func_96559_d());
            this.axis.z = Float.valueOf(dir.func_82599_e());
            myPhi = properties.orbitalPhi;
            myTheta = properties.orbitTheta;
            myRotationalPhi = properties.rotationalPhi;
            myPrevOrbitalTheta = properties.prevOrbitalTheta;
            hasRings = properties.hasRings();
            ringColor = properties.ringColor;
            children = new LinkedList();
            for (Integer i : properties.getChildPlanets()) {
                children.add(DimensionManager.getInstance().getDimensionProperties(i));
            }
            solarOrbitalDistance = properties.getSolarOrbitalDistance();
            isMoon = properties.isMoon();
            if (isMoon) {
                parentProperties = properties.getParentProperties();
                planetOrbitalDistance = properties.getParentOrbitalDistance();
                parentHasRings = parentProperties.hasRings;
                parentHasATM = parentProperties.hasAtmosphere();
                parentRingColor = parentProperties.ringColor;
            }
            float[] sunColorFloat = properties.getSunColor();
            sunColor = new Vec3d((double)sunColorFloat[0], (double)sunColorFloat[1], (double)sunColorFloat[2]);
            primaryStar = properties.getStar();
            if (primaryStar != null) {
                sunSize = properties.getStar().getSize();
            } else {
                primaryStar = DimensionManager.getInstance().getStar(0);
            }
            if (world.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId) {
                boolean bl = isWarp = properties.getParentPlanet() == Integer.MIN_VALUE;
                if (isWarp) {
                    station = (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(mc.field_71439_g.func_180425_c());
                    travelDirection = station.getForwardDirection();
                }
            }
        } else {
            children = new LinkedList<DimensionProperties>();
            isMoon = false;
            atmosphere = DimensionManager.overworldProperties.getAtmosphereDensityAtHeight(mc.func_175606_aa().field_70163_u);
            solarOrbitalDistance = DimensionManager.overworldProperties.orbitalDist;
            sunColor = new Vec3d(1.0, 1.0, 1.0);
            primaryStar = DimensionManager.overworldProperties.getStar();
            properties = DimensionManager.overworldProperties;
        }
        currentplanetphi = myPhi;
        GlStateManager.func_179090_x();
        Vec3d vec3 = Minecraft.func_71410_x().field_71441_e.func_72833_a(this.mc.func_175606_aa(), partialTicks);
        float f1 = (float)vec3.field_72450_a;
        float f2 = (float)vec3.field_72448_b;
        float f3 = (float)vec3.field_72449_c;
        if (this.mc.field_71474_y.field_74337_g) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        f1 = (atmosphereInt = properties.getAtmosphereDensity()) < 1 ? 0.0f : (float)Math.pow(f1, Math.sqrt(Math.max((double)atmosphere, 1.0E-4)));
        f2 = atmosphereInt < 1 ? 0.0f : (float)Math.pow(f2, Math.sqrt(Math.max((double)atmosphere, 1.0E-4)));
        f3 = atmosphereInt < 1 ? 0.0f : (float)Math.pow(f3, Math.sqrt(Math.max((double)atmosphere, 1.0E-4)));
        RenderAsteroidSky.skycolor[0] = f1 *= Math.min(1.0f, atmosphere);
        RenderAsteroidSky.skycolor[1] = f2 *= Math.min(1.0f, atmosphere);
        RenderAsteroidSky.skycolor[2] = f3 *= Math.min(1.0f, atmosphere);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        RenderHelper.func_74518_a();
        float[] afloat = mc.field_71441_e.field_73011_w.func_76560_a(this.celestialAngle, partialTicks);
        if (afloat != null) {
            float f11;
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)mc.field_71441_e.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotated((double)(90.0 - myRotationalPhi), (double)0.0, (double)0.0, (double)1.0);
            f6 = afloat[0];
            f7 = afloat[1];
            f8 = afloat[2];
            if (this.mc.field_71474_y.field_74337_g) {
                f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
                f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                f6 = f9;
                f7 = f10;
                f8 = f11;
            }
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f6, f7, f8, afloat[3] * atmosphere).func_181675_d();
            int b0 = 16;
            for (int j = 0; j <= b0; ++j) {
                f11 = (float)j * (float)Math.PI * 2.0f / (float)b0;
                float f12 = MathHelper.func_76126_a((float)f11);
                float f13 = MathHelper.func_76134_b((float)f11);
                buffer.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3])).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
            GlStateManager.func_179103_j((int)7424);
        }
        shadowColorMultiplier = new float[]{f1, f2, f3};
        GlStateManager.func_179098_w();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GL11.glPushMatrix();
        f6 = atmosphere > 0.0f ? 1.0f - mc.field_71441_e.func_72867_j(partialTicks) * (atmosphere / 100.0f) : 1.0f;
        f7 = 0.0f;
        f8 = 0.0f;
        f9 = 0.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float multiplier = (2.0f - atmosphere) / 2.0f;
        if (mc.field_71441_e.func_175727_C(mc.field_71439_g.func_180425_c().func_177982_a(0, 199, 0))) {
            multiplier *= 1.0f - mc.field_71441_e.func_72867_j(partialTicks);
        }
        GL11.glRotatef((float)((float)myRotationalPhi), (float)0.0f, (float)1.0f, (float)0.0f);
        if (hasRings) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            f10 = 100.0f;
            double ringDist = 0.0;
            mc.field_71446_o.func_110577_a(DimensionProperties.planetRingsNew);
            GL11.glRotated((double)70.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)-10.0, (double)0.0);
            GlStateManager.func_179131_c((float)ringColor[0], (float)ringColor[1], (float)ringColor[2], (float)multiplier);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)f10, ringDist, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)(-f10), ringDist, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)(-f10), ringDist, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)f10, ringDist, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        GlStateManager.func_179090_x();
        float f18 = mc.field_71441_e.func_72880_h(partialTicks) * f6;
        float starAlpha = 1.0f - (1.0f - f18) * atmosphere;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        if (isWarp) {
            for (int i = -3; i < 5; ++i) {
                GL11.glPushMatrix();
                double magnitude = (float)(i * -100) + (float)((System.currentTimeMillis() + 50L) % 2000L) / 20.0f;
                GL11.glTranslated((double)((double)(-travelDirection.func_82599_e()) * magnitude), (double)0.0, (double)((double)travelDirection.func_82601_c() * magnitude));
                GL11.glCallList((int)this.starGLCallList);
                GL11.glPopMatrix();
            }
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)starAlpha);
            GL11.glCallList((int)this.starGLCallList);
            if ((double)atmosphere < 0.5) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(starAlpha / 2.0f));
                GL11.glPushMatrix();
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glCallList((int)this.starGLCallList);
                GL11.glPopMatrix();
            }
            if ((double)atmosphere < 0.25) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(starAlpha / 4.0f));
                GL11.glPushMatrix();
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glCallList((int)this.starGLCallList);
                GL11.glPopMatrix();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        GlStateManager.func_179098_w();
        mc.field_71446_o.func_110577_a(TextureResources.locationSunPng);
        if (!(isWarp || parentProperties != null && parentProperties.isStar())) {
            xrotangle = (float)(properties.getSolarTheta() * 180.0 / Math.PI) % 360.0f;
            this.drawStarAndSubStars(buffer, primaryStar, properties, solarOrbitalDistance, sunSize, sunColor, multiplier);
            xrotangle = 0.0f;
        }
        if (DimensionProperties.AtmosphereTypes.SUPERHIGHPRESSURE.denserThan(DimensionProperties.AtmosphereTypes.getAtmosphereTypeFromValue((int)(100.0f * atmosphere)))) {
            if (isMoon) {
                GL11.glPushMatrix();
                float planetPositionTheta = AstronomicalBodyHelper.getParentPlanetThetaFromMoon(properties.rotationalPeriod, properties.orbitalDist, parentProperties.gravitationalMultiplier, myTheta, properties.baseOrbitTheta);
                GL11.glRotatef((float)((float)myPhi), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)planetPositionTheta, (float)1.0f, (float)0.0f, (float)0.0f);
                float phiAngle = (float)(myPhi * Math.PI / 180.0);
                double x = MathHelper.func_76126_a((float)phiAngle) * MathHelper.func_76134_b((float)((float)myTheta));
                double y = -MathHelper.func_76126_a((float)((float)myTheta));
                double rotation = -1.5707963267948966 + Math.atan2(x, y) - (myTheta - Math.PI) * (double)MathHelper.func_76126_a((float)phiAngle);
                if (parentHasRings) {
                    xrotangle = -planetPositionTheta + (float)(myTheta * 180.0 / Math.PI) % 360.0f;
                }
                shadowColorMultiplier = new float[]{f1, f2, f3};
                this.renderPlanet(buffer, parentProperties, planetOrbitalDistance, multiplier, rotation, false, parentHasRings, (float)Math.pow(parentProperties.getGravitationalMultiplier(), 0.4), shadowColorMultiplier, 1.0f);
                xrotangle = 0.0f;
                GL11.glPopMatrix();
            }
            shadowColorMultiplier[0] = 1.000001f * shadowColorMultiplier[0];
            for (DimensionProperties moons : children) {
                GL11.glPushMatrix();
                float planetPositionTheta = (float)(((double)partialTicks * moons.orbitTheta + (double)(1.0f - partialTicks) * moons.prevOrbitalTheta) * 180.0 / Math.PI);
                float flippedPlanetPositionTheta = 360.0f - planetPositionTheta;
                GL11.glRotatef((float)((float)moons.orbitalPhi), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotated((double)planetPositionTheta, (double)1.0, (double)0.0, (double)0.0);
                float phiAngle = (float)(moons.orbitalPhi * Math.PI / 180.0);
                double x = -MathHelper.func_76126_a((float)phiAngle) * MathHelper.func_76134_b((float)((float)moons.orbitTheta));
                double y = MathHelper.func_76126_a((float)((float)moons.orbitTheta));
                double rotation = -1.5707963267948966 + Math.atan2(x, y) - (moons.orbitTheta - Math.PI) * (double)MathHelper.func_76126_a((float)phiAngle) + Math.PI;
                shadowColorMultiplier = new float[]{f1, f2, f3};
                this.renderPlanet(buffer, moons, moons.getParentOrbitalDistance(), multiplier, rotation, moons.hasAtmosphere(), moons.hasRings, (float)Math.pow(moons.gravitationalMultiplier, 0.4), shadowColorMultiplier, 1.0f);
                GL11.glPopMatrix();
            }
        }
        GlStateManager.func_179127_m();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GL11.glPopMatrix();
        GlStateManager.func_179098_w();
        mc.field_71446_o.func_110577_a(asteroid1);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glCallList((int)this.glSkyList3);
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.2f, (float)0.8f, (float)0.0f);
        mc.field_71446_o.func_110577_a(asteroid2);
        GL11.glCallList((int)this.glSkyList3);
        GL11.glRotatef((float)90.0f, (float)0.2f, (float)0.8f, (float)0.0f);
        mc.field_71446_o.func_110577_a(asteroid3);
        GL11.glCallList((int)this.glSkyList3);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)0);
    }

    protected void drawStarAndSubStars(BufferBuilder buffer, StellarBody sun, DimensionProperties properties, int solarOrbitalDistance, float sunSize, Vec3d sunColor, float multiplier) {
        this.drawStar(buffer, sun, properties, solarOrbitalDistance, sunSize, sunColor, multiplier);
        List<StellarBody> subStars = sun.getSubStars();
        if (subStars != null && !subStars.isEmpty()) {
            GL11.glPushMatrix();
            float phaseInc = 360.0f / (float)subStars.size();
            for (StellarBody subStar : subStars) {
                GL11.glRotatef((float)phaseInc, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glPushMatrix();
                GL11.glRotatef((float)(subStar.getStarSeparation() * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance)), (float)1.0f, (float)0.0f, (float)0.0f);
                float[] color = subStar.getColor();
                this.drawStar(buffer, subStar, properties, solarOrbitalDistance, subStar.getSize(), new Vec3d((double)color[0], (double)color[1], (double)color[2]), multiplier);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }

    protected ResourceLocation getTextureForPlanet(DimensionProperties properties) {
        return properties.getPlanetIcon();
    }

    protected ResourceLocation getTextureForPlanetLEO(DimensionProperties properties) {
        return properties.getPlanetIcon();
    }

    protected EnumFacing getRotationAxis(DimensionProperties properties, BlockPos pos) {
        return EnumFacing.EAST;
    }

    protected void renderPlanet(BufferBuilder buffer, DimensionProperties properties, float planetOrbitalDistance, float alphaMultiplier, double shadowAngle, boolean hasAtmosphere, boolean hasRing, float gravitationalMultiplier, float[] shadowColorMultiplier, float alphaMultiplier2) {
        this.renderPlanet2(buffer, properties, 20.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance) * gravitationalMultiplier, alphaMultiplier, shadowAngle, hasRing, shadowColorMultiplier, alphaMultiplier2);
    }

    protected void renderPlanet2(BufferBuilder buffer, DimensionProperties properties, float size, float alphaMultiplier, double shadowAngle, boolean hasRing, float[] shadowColorMultiplier, float alphaMultiplier2) {
        ResourceLocation icon = this.getTextureForPlanet(properties);
        boolean hasAtmosphere = properties.hasAtmosphere();
        boolean hasDecorators = properties.hasDecorators();
        boolean gasGiant = properties.isGasGiant();
        float[] skyColor = properties.skyColor;
        float[] ringColor = properties.ringColor;
        RenderPlanetarySky.renderPlanetPubHelper(buffer, icon, 0, 0, -20.0, size * 0.2f, alphaMultiplier, shadowAngle, hasAtmosphere, skyColor, ringColor, gasGiant, hasRing, properties.ringAngle, hasDecorators, shadowColorMultiplier, alphaMultiplier2);
    }

    protected Vector3F<Float> getRotateAxis() {
        return this.axis;
    }

    public void renderSphere(double x, double y, double z, float radius, int slices, int stacks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < slices; ++i) {
            for (int j = 0; j < stacks; ++j) {
                double firstLong = Math.PI * 2 * ((double)i / (double)slices);
                double secondLong = Math.PI * 2 * ((double)(i + 1) / (double)slices);
                double firstLat = Math.PI * ((double)j / (double)stacks) - 1.5707963267948966;
                double secondLat = Math.PI * ((double)(j + 1) / (double)stacks) - 1.5707963267948966;
                bufferBuilder.func_181662_b(x + (double)radius * Math.cos(firstLat) * Math.cos(firstLong), y + (double)radius * Math.sin(firstLat), z + (double)radius * Math.cos(firstLat) * Math.sin(firstLong)).func_187315_a(0.0, 0.0).func_181675_d();
                bufferBuilder.func_181662_b(x + (double)radius * Math.cos(secondLat) * Math.cos(firstLong), y + (double)radius * Math.sin(secondLat), z + (double)radius * Math.cos(secondLat) * Math.sin(firstLong)).func_187315_a(1.0, 0.0).func_181675_d();
                bufferBuilder.func_181662_b(x + (double)radius * Math.cos(secondLat) * Math.cos(secondLong), y + (double)radius * Math.sin(secondLat), z + (double)radius * Math.cos(secondLat) * Math.sin(secondLong)).func_187315_a(1.0, 1.0).func_181675_d();
                bufferBuilder.func_181662_b(x + (double)radius * Math.cos(firstLat) * Math.cos(secondLong), y + (double)radius * Math.sin(firstLat), z + (double)radius * Math.cos(firstLat) * Math.sin(secondLong)).func_187315_a(0.0, 1.0).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    protected void drawStar(BufferBuilder buffer, StellarBody sun, DimensionProperties properties, int solarOrbitalDistance, float sunSize, Vec3d sunColor, float multiplier) {
        if (sun != null && sun.isBlackHole()) {
            float m;
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)30.0f, (float)0.0f);
            GL11.glDisable((int)3042);
            GlStateManager.func_179132_a((boolean)true);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
            float f10 = sunSize * 2.0f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
            this.mc.field_71446_o.func_110577_a(TextureResources.locationWhitePng);
            GlStateManager.func_179129_p();
            GlStateManager.func_179124_c((float)skycolor[0], (float)skycolor[1], (float)skycolor[2]);
            this.renderSphere(0.0, 0.0, 0.0, f10, 16, 16);
            GlStateManager.func_179089_o();
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glPopMatrix();
            float diskangle = sun.diskAngle;
            for (m = -xrotangle; m > 360.0f; m -= 360.0f) {
            }
            while (m < 0.0f) {
                m += 360.0f;
            }
            this.mc.field_71446_o.func_110577_a(TextureResources.locationAccretionDiskDense);
            GlStateManager.func_179132_a((boolean)false);
            float speedMult = 5.0f;
            GlStateManager.func_179129_p();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(129600.0f * speedMult))) / (360.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)0.7f, (float)0.55f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            f10 = sunSize * 6.5f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
            buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
            this.mc.field_71446_o.func_110577_a(TextureResources.locationAccretionDisk);
            for (int i = 0; i < 3; ++i) {
                speedMult = 10.0f;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)100.01f, (float)0.0f);
                GL11.glRotatef((float)((float)currentplanetphi), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)m, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)diskangle, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 36000.0f))) / (100.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(120 * i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.4f, (float)0.3f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 40.0f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
                GL11.glRotatef((float)((float)currentplanetphi), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)m, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)diskangle, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 50.0f))) / (50.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(120 * i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)0.8f, (float)0.7f, (float)0.4f, (float)0.3f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 30.0f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)99.99f, (float)0.0f);
                GL11.glRotatef((float)((float)currentplanetphi), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)m, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)diskangle, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 25.0f))) / (25.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(120 * i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)0.2f, (float)0.4f, (float)1.0f, (float)0.3f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 15.0f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
            }
            GlStateManager.func_179132_a((boolean)true);
            GL11.glClear((int)256);
            GlStateManager.func_179132_a((boolean)false);
            GL11.glPopMatrix();
            GlStateManager.func_179089_o();
        } else {
            this.mc.field_71446_o.func_110577_a(TextureResources.locationSunPng);
            GlStateManager.func_179131_c((float)((float)sunColor.field_72450_a), (float)((float)sunColor.field_72448_b), (float)((float)sunColor.field_72449_c), (float)Math.min(multiplier * 2.0f, 1.0f));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float f10 = sunSize * 15.0f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
            buffer.func_181662_b((double)(-f10), 120.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)f10, 120.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)f10, 120.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(-f10), 120.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }
}

