/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.cable;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import zmaster587.advancedRocketry.tile.cables.TilePipe;
import zmaster587.libVulpes.util.SingleEntry;

public class CableNetwork {
    protected static HashSet<Integer> usedIds = new HashSet();
    protected int numCables = 0;
    int networkID;
    CopyOnWriteArraySet<Map.Entry<TileEntity, EnumFacing>> sources = new CopyOnWriteArraySet();
    CopyOnWriteArraySet<Map.Entry<TileEntity, EnumFacing>> sinks = new CopyOnWriteArraySet();

    protected CableNetwork() {
    }

    public static CableNetwork initWithID(int id) {
        CableNetwork net = new CableNetwork();
        net.networkID = id;
        return net;
    }

    public static CableNetwork initNetwork() {
        Random random = new Random(System.currentTimeMillis());
        int id = random.nextInt();
        while (usedIds.contains(id)) {
            id = random.nextInt();
        }
        CableNetwork net = new CableNetwork();
        usedIds.add(id);
        net.networkID = id;
        return net;
    }

    public Set<Map.Entry<TileEntity, EnumFacing>> getSources() {
        return this.sources;
    }

    public Set<Map.Entry<TileEntity, EnumFacing>> getSinks() {
        return this.sinks;
    }

    public void addSource(TileEntity tile, EnumFacing dir) {
        for (Map.Entry<TileEntity, EnumFacing> entry : this.sources) {
            TileEntity tile2 = entry.getKey();
            if (tile2.equals(tile)) {
                return;
            }
            if (tile2.func_174877_v().compareTo((Vec3i)tile.func_174877_v()) != 0) continue;
            this.sources.remove(entry);
            break;
        }
        this.sources.add((Map.Entry<TileEntity, EnumFacing>)new SingleEntry((Object)tile, (Object)dir));
    }

    public void addSink(TileEntity tile, EnumFacing dir) {
        for (Map.Entry<TileEntity, EnumFacing> entry : this.sinks) {
            TileEntity tile2 = entry.getKey();
            if (tile2.equals(tile)) {
                return;
            }
            if (tile2.func_174877_v().compareTo((Vec3i)tile.func_174877_v()) != 0) continue;
            this.sinks.remove(entry);
            break;
        }
        this.sinks.add((Map.Entry<TileEntity, EnumFacing>)new SingleEntry((Object)tile, (Object)dir));
    }

    public void writeToNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public void removeFromAll(TileEntity tile) {
        TileEntity tile2;
        for (Map.Entry<TileEntity, EnumFacing> entry : this.sources) {
            tile2 = entry.getKey();
            if (tile2.func_174877_v().compareTo((Vec3i)tile.func_174877_v()) != 0) continue;
            this.sources.remove(entry);
            break;
        }
        for (Map.Entry<TileEntity, EnumFacing> entry : this.sinks) {
            tile2 = entry.getKey();
            if (tile2.func_174877_v().compareTo((Vec3i)tile.func_174877_v()) != 0) continue;
            this.sinks.remove(entry);
            break;
        }
    }

    public String toString() {
        TileEntity tile;
        StringBuilder output = new StringBuilder("NumCables:   " + this.numCables + "     Sources: ");
        for (Map.Entry<TileEntity, EnumFacing> obj : this.sources) {
            tile = obj.getKey();
            output.append(tile.func_174877_v().func_177958_n()).append(",").append(tile.func_174877_v().func_177956_o()).append(",").append(tile.func_174877_v().func_177952_p()).append(" ");
        }
        output.append("    Sinks: ");
        for (Map.Entry<TileEntity, EnumFacing> obj : this.sinks) {
            tile = obj.getKey();
            output.append(tile.func_174877_v().func_177958_n()).append(",").append(tile.func_174877_v().func_177956_o()).append(",").append(tile.func_174877_v().func_177952_p()).append(" ");
        }
        return output.toString();
    }

    public boolean merge(CableNetwork cableNetwork) {
        this.sinks.addAll(cableNetwork.getSinks());
        for (Map.Entry<TileEntity, EnumFacing> obj : cableNetwork.getSinks()) {
            for (Map.Entry<TileEntity, EnumFacing> obj2 : this.sinks) {
                if (obj.getKey().func_174877_v().compareTo((Vec3i)obj2.getKey().func_174877_v()) != 0 || obj.getValue() != obj2.getValue()) continue;
                return false;
            }
            this.sinks.add(obj);
        }
        for (Map.Entry<TileEntity, EnumFacing> obj : cableNetwork.getSources()) {
            for (Map.Entry<TileEntity, EnumFacing> obj2 : this.sources) {
                if (obj.getKey().func_174877_v().compareTo((Vec3i)obj2.getKey().func_174877_v()) != 0 || obj.getValue() != obj2.getValue()) continue;
                return false;
            }
            this.sources.add(obj);
        }
        return true;
    }

    public void addPipeToNetwork(TilePipe tile) {
        ++this.numCables;
    }

    public void tick() {
    }

    public void removePipeFromNetwork(TilePipe tilePipe) {
        --this.numCables;
    }
}

