/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import java.util.LinkedList;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.IFuelTank;
import zmaster587.advancedRocketry.api.IRocketEngine;
import zmaster587.libVulpes.block.BlockFullyRotatable;

public class BlockFuelTank
extends BlockFullyRotatable
implements IFuelTank {
    public static final PropertyEnum<TankStates> TANKSTATES = PropertyEnum.func_177709_a((String)"tankstates", TankStates.class);

    public BlockFuelTank(Material mat) {
        super(mat);
        this.func_180632_j(this.func_176223_P().func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.MIDDLE)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int tankstate = meta % 3;
        int rotationstate = meta / 3;
        IBlockState state = this.func_176223_P().func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.values()[tankstate]));
        if (rotationstate == 0) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        }
        if (rotationstate == 1) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
        }
        if (rotationstate == 2) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.UP) {
            i = 0;
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            i = 1;
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            i = 2;
        }
        int v = ((TankStates)((Object)state.func_177229_b(TANKSTATES))).ordinal() + i * 3;
        return v;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TANKSTATES, FACING});
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.DOWN) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.DOWN || world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.UP) {
            int i = world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177229_b((IProperty)FACING) == EnumFacing.UP ? 1 : 0;
            if ((i += world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177229_b((IProperty)FACING) == EnumFacing.UP || world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() instanceof IRocketEngine ? 2 : 0) == 1) {
                return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.BOTTOM));
            }
            if (i == 2) {
                return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.TOP));
            }
            return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.MIDDLE));
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST || world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            int i = world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177229_b((IProperty)FACING) == EnumFacing.EAST || world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c() instanceof IRocketEngine ? 1 : 0;
            if ((i += world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177229_b((IProperty)FACING) == EnumFacing.EAST || world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c() instanceof IRocketEngine ? 2 : 0) == 1) {
                return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.BOTTOM));
            }
            if (i == 2) {
                return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.TOP));
            }
            return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.MIDDLE));
        }
        if (world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH || world.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            int i = world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH || world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c() instanceof IRocketEngine ? 1 : 0;
            if ((i += world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH || world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c() instanceof IRocketEngine ? 2 : 0) == 1) {
                return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.BOTTOM));
            }
            if (i == 2) {
                return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.TOP));
            }
            return state.func_177226_a(TANKSTATES, (Comparable)((Object)TankStates.MIDDLE));
        }
        return state;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        if (Math.abs(placer.field_70125_A) > 50.0f) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)(placer.field_70125_A > 0.0f ? EnumFacing.UP : EnumFacing.DOWN)), 2);
        } else {
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        }
        state = world.func_180495_p(pos);
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.DOWN) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST));
        }
        LinkedList<Comparable> nextblocks = new LinkedList<Comparable>();
        if (world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177229_b((IProperty)FACING) == EnumFacing.UP) {
            nextblocks.add(world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177229_b((IProperty)FACING));
        }
        if (world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177229_b((IProperty)FACING) == EnumFacing.UP) {
            nextblocks.add(world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177229_b((IProperty)FACING));
        }
        if (world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            nextblocks.add(world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177229_b((IProperty)FACING));
        }
        if (world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            nextblocks.add(world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177229_b((IProperty)FACING));
        }
        if (world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            nextblocks.add(world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177229_b((IProperty)FACING));
        }
        if (world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c() == this && world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            nextblocks.add(world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177229_b((IProperty)FACING));
        }
        if (!nextblocks.isEmpty()) {
            boolean rotate = true;
            EnumFacing targetfacing = null;
            targetfacing = (EnumFacing)nextblocks.get(0);
            for (int i = 0; i < nextblocks.size(); ++i) {
                if (nextblocks.get(i) == targetfacing) continue;
                rotate = false;
            }
            if (rotate) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)targetfacing));
            }
        }
    }

    @Override
    public int getMaxFill(World world, BlockPos pos, IBlockState state) {
        return 1000;
    }

    public static enum TankStates implements IStringSerializable
    {
        TOP,
        BOTTOM,
        MIDDLE;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

