/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.satellite;

import net.minecraft.nbt.NBTTagCompound;
import zmaster587.advancedRocketry.util.IWeighted;

public class SatelliteProperties
implements IWeighted {
    private int powerGeneration;
    private int powerStorage;
    private int maxData;
    private long id = -1L;
    private String satType = null;
    private float weight;

    public SatelliteProperties() {
    }

    public SatelliteProperties(int powerGeneration, int powerStorage, String satType, int maxData, float weight) {
        this();
        this.powerGeneration = powerGeneration;
        this.powerStorage = powerStorage;
        this.satType = satType;
        this.maxData = maxData;
        this.weight = weight;
    }

    public int getPropertyFlag() {
        int flag = 0;
        if (this.satType != null) {
            flag |= Property.MAIN.getFlag();
        }
        if (this.powerGeneration != 0) {
            flag |= Property.POWER_GEN.getFlag();
        }
        if (this.powerStorage != 0) {
            flag |= Property.BATTERY.getFlag();
        }
        if (this.maxData != 0) {
            flag |= Property.DATA.getFlag();
        }
        return flag;
    }

    public long getId() {
        return this.id;
    }

    public boolean setId(long id) {
        if (this.id == -1L) {
            this.id = id;
            return true;
        }
        return false;
    }

    public int getPowerGeneration() {
        return this.powerGeneration;
    }

    public SatelliteProperties setPowerGeneration(int powerGeneration) {
        this.powerGeneration = powerGeneration;
        return this;
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    public int getPowerStorage() {
        return this.powerStorage;
    }

    public SatelliteProperties setPowerStorage(int powerStorage) {
        this.powerStorage = powerStorage;
        return this;
    }

    public SatelliteProperties setMaxData(int maxData) {
        this.maxData = maxData;
        return this;
    }

    public int getMaxDataStorage() {
        return this.maxData;
    }

    public String getSatelliteType() {
        return this.satType;
    }

    public SatelliteProperties setSatelliteType(String type) {
        this.satType = type;
        return this;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("powerGeneration", this.powerGeneration);
        nbt.func_74768_a("powerStorage", this.powerStorage);
        nbt.func_74778_a("dataType", this.satType);
        nbt.func_74772_a("satId", this.id);
        nbt.func_74768_a("maxData", this.maxData);
        nbt.func_74776_a("weight", this.weight);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.powerGeneration = nbt.func_74762_e("powerGeneration");
        this.powerStorage = nbt.func_74762_e("powerStorage");
        this.satType = nbt.func_74779_i("dataType");
        this.id = nbt.func_74763_f("satId");
        this.maxData = nbt.func_74762_e("maxData");
        this.weight = nbt.func_74760_g("weight");
    }

    public static enum Property {
        MAIN,
        DATA,
        POWER_GEN,
        BATTERY;


        public int getFlag() {
            return 1 << this.ordinal();
        }

        public boolean isOfType(int flag) {
            return (flag & this.getFlag()) != 0;
        }
    }
}

