/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.util.WeightEngine;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class StatsRocket {
    private static final String TAGNAME = "rocketStats";
    public static final int INVALID_SEAT = Integer.MIN_VALUE;
    private final List<HashedBlockPosition> passengerSeats = new ArrayList<HashedBlockPosition>();
    public int orbitHeight;
    public float injectionBurnLenghtMult;
    HashedBlockPosition pilotSeatPos;
    private int thrust = 0;
    private float weight = 0.0f;
    private float drillingPower = 0.0f;
    private String fuelFluid = "null";
    private String oxidizerFluid = "null";
    private String workingFluid = "null";
    private int fuelMonopropellant = 0;
    private int fuelNuclearWorkingFluid;
    private int fuelBipropellant = 0;
    private int fuelOxidizer = 0;
    private int fuelIon;
    private int fuelWarp;
    private int fuelImpulse;
    private int fuelCapacityMonopropellant;
    private int fuelCapacityBipropellant;
    private int fuelCapacityOxidizer;
    private int fuelCapacityNuclearWorkingFluid;
    private int fuelCapacityIon;
    private int fuelCapacityWarp;
    private int fuelCapacityImpulse;
    private int fuelRateMonopropellant = 0;
    private int fuelRateBipropellant = 0;
    private int fuelRateOxidizer = 0;
    private int fuelRateNuclearWorkingFluid;
    private int fuelRateIon;
    private int fuelRateWarp;
    private int fuelRateImpulse;
    private int fuelBaseRateMonopropellant;
    private int fuelBaseRateBipropellant;
    private int fuelBaseRateOxidizer;
    private int fuelBaseRateNuclearWorkingFluid;
    private int fuelBaseRateIon;
    private int fuelBaseRateWarp;
    private int fuelBaseRateImpulse;
    private List<Vector3F<Float>> engineLoc;
    private HashMap<String, Object> statTags;

    public StatsRocket() {
        this.orbitHeight = ARConfiguration.getCurrentConfig().orbit;
        this.injectionBurnLenghtMult = 1.0f;
        this.pilotSeatPos = new HashedBlockPosition(0, 0, 0);
        this.pilotSeatPos.x = Integer.MIN_VALUE;
        this.engineLoc = new ArrayList<Vector3F<Float>>();
        this.statTags = new HashMap();
    }

    public static StatsRocket createFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(TAGNAME)) {
            NBTTagCompound stats = nbt.func_74775_l(TAGNAME);
            StatsRocket statsRocket = new StatsRocket();
            statsRocket.readFromNBT(stats);
            return statsRocket;
        }
        return new StatsRocket();
    }

    public int getSeatX() {
        return this.pilotSeatPos.x;
    }

    public int getSeatY() {
        return this.pilotSeatPos.y;
    }

    public int getSeatZ() {
        return this.pilotSeatPos.z;
    }

    public HashedBlockPosition getPassengerSeat(int index) {
        return this.passengerSeats.get(index);
    }

    public int getNumPassengerSeats() {
        return this.passengerSeats.size();
    }

    public int getThrust() {
        return (int)((double)this.thrust * ARConfiguration.getCurrentConfig().rocketThrustMultiplier);
    }

    public void setThrust(int thrust) {
        this.thrust = thrust;
    }

    public float getWeight_NoFuel() {
        return this.weight;
    }

    public float getWeight() {
        float fluidWeight = 0.0f;
        if (ARConfiguration.getCurrentConfig().advancedWeightSystem) {
            Fluid f;
            if (FluidRegistry.isFluidRegistered((String)this.getFuelFluid())) {
                f = FluidRegistry.getFluid((String)this.getFuelFluid());
                fluidWeight += WeightEngine.INSTANCE.getWeight(f, this.getFuelAmount(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT));
                fluidWeight += WeightEngine.INSTANCE.getWeight(f, this.getFuelAmount(FuelRegistry.FuelType.LIQUID_BIPROPELLANT));
            }
            if (FluidRegistry.isFluidRegistered((String)this.getOxidizerFluid())) {
                f = FluidRegistry.getFluid((String)this.getOxidizerFluid());
                fluidWeight += WeightEngine.INSTANCE.getWeight(f, this.getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER));
            }
        }
        return this.weight + fluidWeight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public String getFuelFluid() {
        return this.fuelFluid;
    }

    public void setFuelFluid(String fuelFluid) {
        this.fuelFluid = fuelFluid;
    }

    public String getOxidizerFluid() {
        return this.oxidizerFluid;
    }

    public void setOxidizerFluid(String oxidizerFluid) {
        this.oxidizerFluid = oxidizerFluid;
    }

    public String getWorkingFluid() {
        return this.workingFluid;
    }

    public void setWorkingFluid(String workingFluid) {
        this.workingFluid = workingFluid;
    }

    public float getDrillingPower() {
        return this.drillingPower;
    }

    public void setDrillingPower(float power) {
        this.drillingPower = power;
    }

    public float getAcceleration(float gravitationalMultiplier) {
        float N = (float)this.getThrust() - this.getWeight() * (ARConfiguration.getCurrentConfig().gravityAffectsFuel ? gravitationalMultiplier : 1.0f);
        return N / this.getWeight() / 20.0f;
    }

    public List<Vector3F<Float>> getEngineLocations() {
        return this.engineLoc;
    }

    public boolean isNuclear() {
        return this.fuelBaseRateNuclearWorkingFluid > 0;
    }

    public void setSeatLocation(int x, int y, int z) {
        this.pilotSeatPos.x = x;
        this.pilotSeatPos.y = (short)y;
        this.pilotSeatPos.z = z;
    }

    public void addPassengerSeat(int x, int y, int z) {
        if (!this.hasSeat()) {
            this.setSeatLocation(x, y, z);
        }
        this.passengerSeats.add(new HashedBlockPosition(x, y, z));
    }

    public void addEngineLocation(float x, float y, float z) {
        this.engineLoc.add((Vector3F<Float>)new Vector3F((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z)));
    }

    public void clearEngineLocations() {
        this.engineLoc.clear();
    }

    public StatsRocket copy() {
        StatsRocket stat = new StatsRocket();
        stat.thrust = this.thrust;
        stat.weight = this.weight;
        stat.fuelFluid = this.fuelFluid;
        stat.oxidizerFluid = this.oxidizerFluid;
        stat.workingFluid = this.workingFluid;
        stat.drillingPower = this.drillingPower;
        for (FuelRegistry.FuelType type : FuelRegistry.FuelType.values()) {
            stat.setFuelAmount(type, this.getFuelAmount(type));
            stat.setFuelRate(type, this.getFuelRate(type));
            stat.setFuelCapacity(type, this.getFuelCapacity(type));
            stat.setBaseFuelRate(type, this.getBaseFuelRate(type));
        }
        stat.pilotSeatPos = new HashedBlockPosition(this.pilotSeatPos.x, (int)this.pilotSeatPos.y, this.pilotSeatPos.z);
        stat.passengerSeats.addAll(this.passengerSeats);
        stat.engineLoc = new ArrayList<Vector3F<Float>>(this.engineLoc);
        stat.statTags = new HashMap<String, Object>(this.statTags);
        return stat;
    }

    public int getFuelAmount(@Nullable FuelRegistry.FuelType type) {
        if (type != null) {
            switch (type) {
                case WARP: {
                    return this.fuelWarp;
                }
                case IMPULSE: {
                    return this.fuelImpulse;
                }
                case ION: {
                    return this.fuelIon;
                }
                case LIQUID_MONOPROPELLANT: {
                    return this.fuelMonopropellant;
                }
                case LIQUID_BIPROPELLANT: {
                    return this.fuelBipropellant;
                }
                case LIQUID_OXIDIZER: {
                    return this.fuelOxidizer;
                }
                case NUCLEAR_WORKING_FLUID: {
                    return this.fuelNuclearWorkingFluid;
                }
            }
        }
        return 0;
    }

    public int getFuelCapacity(@Nullable FuelRegistry.FuelType type) {
        if (type != null) {
            switch (type) {
                case WARP: {
                    return this.fuelCapacityWarp;
                }
                case IMPULSE: {
                    return this.fuelCapacityImpulse;
                }
                case ION: {
                    return this.fuelCapacityIon;
                }
                case LIQUID_MONOPROPELLANT: {
                    return this.fuelCapacityMonopropellant;
                }
                case LIQUID_BIPROPELLANT: {
                    return this.fuelCapacityBipropellant;
                }
                case LIQUID_OXIDIZER: {
                    return this.fuelCapacityOxidizer;
                }
                case NUCLEAR_WORKING_FLUID: {
                    return this.fuelCapacityNuclearWorkingFluid;
                }
            }
        }
        return 0;
    }

    public int getFuelRate(@Nullable FuelRegistry.FuelType type) {
        if (!ARConfiguration.getCurrentConfig().rocketRequireFuel || type == null) {
            return 0;
        }
        switch (type) {
            case WARP: {
                return this.fuelRateWarp;
            }
            case IMPULSE: {
                return this.fuelRateImpulse;
            }
            case ION: {
                return this.fuelRateIon;
            }
            case LIQUID_MONOPROPELLANT: {
                return this.fuelRateMonopropellant;
            }
            case LIQUID_BIPROPELLANT: {
                return this.fuelRateBipropellant;
            }
            case LIQUID_OXIDIZER: {
                return this.fuelRateOxidizer;
            }
            case NUCLEAR_WORKING_FLUID: {
                return this.fuelRateNuclearWorkingFluid;
            }
        }
        return 0;
    }

    public int getBaseFuelRate(@Nullable FuelRegistry.FuelType type) {
        if (!ARConfiguration.getCurrentConfig().rocketRequireFuel || type == null) {
            return 0;
        }
        switch (type) {
            case WARP: {
                return this.fuelBaseRateWarp;
            }
            case IMPULSE: {
                return this.fuelBaseRateImpulse;
            }
            case ION: {
                return this.fuelBaseRateIon;
            }
            case LIQUID_MONOPROPELLANT: {
                return this.fuelBaseRateMonopropellant;
            }
            case LIQUID_BIPROPELLANT: {
                return this.fuelBaseRateBipropellant;
            }
            case LIQUID_OXIDIZER: {
                return this.fuelBaseRateOxidizer;
            }
            case NUCLEAR_WORKING_FLUID: {
                return this.fuelBaseRateNuclearWorkingFluid;
            }
        }
        return 0;
    }

    public void setFuelAmount(@Nonnull FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelWarp = amt;
                break;
            }
            case IMPULSE: {
                this.fuelImpulse = amt;
                break;
            }
            case ION: {
                this.fuelIon = amt;
                break;
            }
            case LIQUID_MONOPROPELLANT: {
                this.fuelMonopropellant = amt;
                break;
            }
            case LIQUID_BIPROPELLANT: {
                this.fuelBipropellant = amt;
                break;
            }
            case LIQUID_OXIDIZER: {
                this.fuelOxidizer = amt;
                break;
            }
            case NUCLEAR_WORKING_FLUID: {
                this.fuelNuclearWorkingFluid = amt;
            }
        }
    }

    public void setFuelRate(@Nonnull FuelRegistry.FuelType type, int rate) {
        switch (type) {
            case WARP: {
                this.fuelRateWarp = rate;
                break;
            }
            case IMPULSE: {
                this.fuelRateImpulse = rate;
                break;
            }
            case ION: {
                this.fuelRateIon = rate;
                break;
            }
            case LIQUID_MONOPROPELLANT: {
                this.fuelRateMonopropellant = rate;
                break;
            }
            case LIQUID_BIPROPELLANT: {
                this.fuelRateBipropellant = rate;
                break;
            }
            case LIQUID_OXIDIZER: {
                this.fuelRateOxidizer = rate;
                break;
            }
            case NUCLEAR_WORKING_FLUID: {
                this.fuelRateNuclearWorkingFluid = rate;
            }
        }
    }

    public void setBaseFuelRate(@Nonnull FuelRegistry.FuelType type, int rate) {
        switch (type) {
            case WARP: {
                this.fuelBaseRateWarp = rate;
                break;
            }
            case IMPULSE: {
                this.fuelBaseRateImpulse = rate;
                break;
            }
            case ION: {
                this.fuelBaseRateIon = rate;
                break;
            }
            case LIQUID_MONOPROPELLANT: {
                this.fuelBaseRateMonopropellant = rate;
                break;
            }
            case LIQUID_BIPROPELLANT: {
                this.fuelBaseRateBipropellant = rate;
                break;
            }
            case LIQUID_OXIDIZER: {
                this.fuelBaseRateOxidizer = rate;
                break;
            }
            case NUCLEAR_WORKING_FLUID: {
                this.fuelBaseRateNuclearWorkingFluid = rate;
            }
        }
    }

    public void setFuelCapacity(@Nonnull FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelCapacityWarp = amt;
                break;
            }
            case IMPULSE: {
                this.fuelCapacityImpulse = amt;
                break;
            }
            case ION: {
                this.fuelCapacityIon = amt;
                break;
            }
            case LIQUID_MONOPROPELLANT: {
                this.fuelCapacityMonopropellant = amt;
                break;
            }
            case LIQUID_BIPROPELLANT: {
                this.fuelCapacityBipropellant = amt;
                break;
            }
            case LIQUID_OXIDIZER: {
                this.fuelCapacityOxidizer = amt;
                break;
            }
            case NUCLEAR_WORKING_FLUID: {
                this.fuelCapacityNuclearWorkingFluid = amt;
            }
        }
    }

    public int addFuelAmount(@Nonnull FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                int maxAddWarp = this.fuelCapacityWarp - this.fuelWarp;
                int amountToAddWarp = Math.min(amt, maxAddWarp);
                this.fuelWarp += amountToAddWarp;
                return amountToAddWarp;
            }
            case IMPULSE: {
                int maxAddImpulse = this.fuelCapacityImpulse - this.fuelImpulse;
                int amountToAddImpulse = Math.min(amt, maxAddImpulse);
                this.fuelImpulse += amountToAddImpulse;
                return amountToAddImpulse;
            }
            case ION: {
                int maxAddIon = this.fuelCapacityIon - this.fuelIon;
                int amountToAddIon = Math.min(amt, maxAddIon);
                this.fuelIon += amountToAddIon;
                return amountToAddIon;
            }
            case LIQUID_MONOPROPELLANT: {
                int maxAddMonopropellant = this.fuelCapacityMonopropellant - this.fuelMonopropellant;
                int amountToAddMonopropellant = Math.min(amt, maxAddMonopropellant);
                this.fuelMonopropellant += amountToAddMonopropellant;
                return amountToAddMonopropellant;
            }
            case LIQUID_BIPROPELLANT: {
                int maxAddBipropellant = this.fuelCapacityBipropellant - this.fuelBipropellant;
                int amountToAddBipropellant = Math.min(amt, maxAddBipropellant);
                this.fuelBipropellant += amountToAddBipropellant;
                return amountToAddBipropellant;
            }
            case LIQUID_OXIDIZER: {
                int maxAddOxidizer = this.fuelCapacityOxidizer - this.fuelOxidizer;
                int amountToAddOxidizer = Math.min(amt, maxAddOxidizer);
                this.fuelOxidizer += amountToAddOxidizer;
                return amountToAddOxidizer;
            }
            case NUCLEAR_WORKING_FLUID: {
                int maxAddNuclearWorkingFluid = this.fuelCapacityNuclearWorkingFluid - this.fuelNuclearWorkingFluid;
                int amountToAddNuclearWorkingFluid = Math.min(amt, maxAddNuclearWorkingFluid);
                this.fuelNuclearWorkingFluid += amountToAddNuclearWorkingFluid;
                return amountToAddNuclearWorkingFluid;
            }
        }
        return 0;
    }

    public boolean hasSeat() {
        return this.pilotSeatPos.x != Integer.MIN_VALUE;
    }

    public void reset() {
        this.thrust = 0;
        this.weight = 0.0f;
        this.fuelFluid = "null";
        this.oxidizerFluid = "null";
        this.drillingPower = 0.0f;
        for (FuelRegistry.FuelType type : FuelRegistry.FuelType.values()) {
            this.setFuelAmount(type, 0);
            this.setFuelRate(type, 0);
            this.setFuelCapacity(type, 0);
        }
        this.fuelMonopropellant = 0;
        this.fuelBipropellant = 0;
        this.fuelOxidizer = 0;
        this.pilotSeatPos.x = Integer.MIN_VALUE;
        this.clearEngineLocations();
        this.passengerSeats.clear();
        this.statTags.clear();
    }

    public void reset_no_fuel() {
        this.thrust = 0;
        this.weight = 0.0f;
        this.drillingPower = 0.0f;
        this.pilotSeatPos.x = Integer.MIN_VALUE;
        this.clearEngineLocations();
        this.passengerSeats.clear();
        this.statTags.clear();
    }

    public void setStatTag(String str, float value) {
        this.statTags.put(str, Float.valueOf(value));
    }

    public void setStatTag(String str, int value) {
        this.statTags.put(str, value);
    }

    public Object getStatTag(String str) {
        Object obj = this.statTags.get(str);
        return obj == null ? Integer.valueOf(0) : obj;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        HashedBlockPosition vec;
        int[] locs;
        NBTTagCompound stats = new NBTTagCompound();
        stats.func_74768_a("thrust", this.thrust);
        stats.func_74776_a("weight", this.weight);
        stats.func_74776_a("drillingPower", this.drillingPower);
        stats.func_74778_a("fuelFluid", this.fuelFluid);
        stats.func_74778_a("oxidizerFluid", this.oxidizerFluid);
        stats.func_74778_a("workingFluid", this.workingFluid);
        stats.func_74768_a("fuelMonopropellant", this.fuelMonopropellant);
        stats.func_74768_a("fuelBipropellant", this.fuelBipropellant);
        stats.func_74768_a("fuelOxidizer", this.fuelOxidizer);
        stats.func_74768_a("fuelImpulse", this.fuelImpulse);
        stats.func_74768_a("fuelIon", this.fuelIon);
        stats.func_74768_a("fuelNuclearWorkingFluid", this.fuelNuclearWorkingFluid);
        stats.func_74768_a("fuelWarp", this.fuelWarp);
        stats.func_74768_a("fuelCapacityMonopropellant", this.fuelCapacityMonopropellant);
        stats.func_74768_a("fuelCapacityBipropellant", this.fuelCapacityBipropellant);
        stats.func_74768_a("fuelCapacityOxidizer", this.fuelCapacityOxidizer);
        stats.func_74768_a("fuelCapacityImpulse", this.fuelCapacityImpulse);
        stats.func_74768_a("fuelCapacityIon", this.fuelCapacityIon);
        stats.func_74768_a("fuelCapacityNuclearWorkingFluid", this.fuelCapacityNuclearWorkingFluid);
        stats.func_74768_a("fuelCapacityWarp", this.fuelCapacityWarp);
        stats.func_74768_a("fuelRateMonopropellant", this.fuelRateMonopropellant);
        stats.func_74768_a("fuelRateBipropellant", this.fuelRateBipropellant);
        stats.func_74768_a("fuelRateOxidizer", this.fuelRateOxidizer);
        stats.func_74768_a("fuelRateImpulse", this.fuelRateImpulse);
        stats.func_74768_a("fuelRateIon", this.fuelRateIon);
        stats.func_74768_a("fuelRateNuclearWorkingFluid", this.fuelRateNuclearWorkingFluid);
        stats.func_74768_a("fuelRateWarp", this.fuelRateWarp);
        stats.func_74776_a("fuelBaseRateMonopropellant", (float)this.fuelBaseRateMonopropellant);
        stats.func_74776_a("fuelBaseRateBipropellant", (float)this.fuelBaseRateBipropellant);
        stats.func_74776_a("fuelBaseRateOxidizer", (float)this.fuelBaseRateOxidizer);
        stats.func_74776_a("fuelBaseRateImpulse", (float)this.fuelBaseRateImpulse);
        stats.func_74776_a("fuelBaseRateIon", (float)this.fuelBaseRateIon);
        stats.func_74776_a("fuelBaseRateNuclearWorkingFluid", (float)this.fuelBaseRateNuclearWorkingFluid);
        stats.func_74776_a("fuelBaseRateWarp", (float)this.fuelBaseRateWarp);
        NBTTagCompound dynStats = new NBTTagCompound();
        for (String key : this.statTags.keySet()) {
            Object obj = this.statTags.get(key);
            if (obj instanceof Float) {
                dynStats.func_74776_a(key, ((Float)obj).floatValue());
                continue;
            }
            if (!(obj instanceof Integer)) continue;
            dynStats.func_74768_a(key, ((Integer)obj).intValue());
        }
        if (!dynStats.func_82582_d()) {
            stats.func_74782_a("dynStats", (NBTBase)dynStats);
        }
        stats.func_74768_a("playerXPos", this.pilotSeatPos.x);
        stats.func_74768_a("playerYPos", (int)this.pilotSeatPos.y);
        stats.func_74768_a("playerZPos", this.pilotSeatPos.z);
        if (!this.engineLoc.isEmpty()) {
            locs = new int[this.engineLoc.size() * 3];
            int i = 0;
            while (i / 3 < this.engineLoc.size()) {
                vec = this.engineLoc.get(i / 3);
                locs[i] = (int)(((Float)vec.x).floatValue() * 2.0f);
                locs[i + 1] = (int)(((Float)vec.y).floatValue() * 2.0f);
                locs[i + 2] = (int)(((Float)vec.z).floatValue() * 2.0f);
                i += 3;
            }
            stats.func_74783_a("engineLoc", locs);
        }
        if (!this.passengerSeats.isEmpty()) {
            locs = new int[this.passengerSeats.size() * 3];
            int i = 0;
            while (i / 3 < this.passengerSeats.size()) {
                vec = this.passengerSeats.get(i / 3);
                locs[i] = vec.x;
                locs[i + 1] = vec.y;
                locs[i + 2] = vec.z;
                i += 3;
            }
            stats.func_74783_a("passengerSeats", locs);
        }
        nbt.func_74782_a(TAGNAME, (NBTBase)stats);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.reset();
        if (nbt.func_74764_b(TAGNAME)) {
            int[] locations;
            NBTTagCompound stats = nbt.func_74775_l(TAGNAME);
            this.thrust = stats.func_74762_e("thrust");
            this.weight = stats.func_74760_g("weight");
            this.fuelFluid = stats.func_74779_i("fuelFluid");
            this.oxidizerFluid = stats.func_74779_i("oxidizerFluid");
            this.workingFluid = stats.func_74779_i("workingFluid");
            this.drillingPower = stats.func_74760_g("drillingPower");
            this.fuelMonopropellant = stats.func_74762_e("fuelMonopropellant");
            this.fuelBipropellant = stats.func_74762_e("fuelBipropellant");
            this.fuelOxidizer = stats.func_74762_e("fuelOxidizer");
            this.fuelImpulse = stats.func_74762_e("fuelImpulse");
            this.fuelIon = stats.func_74762_e("fuelIon");
            this.fuelNuclearWorkingFluid = stats.func_74762_e("fuelNuclearWorkingFluid");
            this.fuelWarp = stats.func_74762_e("fuelWarp");
            this.fuelCapacityMonopropellant = stats.func_74762_e("fuelCapacityMonopropellant");
            this.fuelCapacityBipropellant = stats.func_74762_e("fuelCapacityBipropellant");
            this.fuelCapacityOxidizer = stats.func_74762_e("fuelCapacityOxidizer");
            this.fuelCapacityImpulse = stats.func_74762_e("fuelCapacityImpulse");
            this.fuelCapacityIon = stats.func_74762_e("fuelCapacityIon");
            this.fuelCapacityNuclearWorkingFluid = stats.func_74762_e("fuelCapacityNuclearWorkingFluid");
            this.fuelCapacityWarp = stats.func_74762_e("fuelCapacityWarp");
            this.fuelRateMonopropellant = stats.func_74762_e("fuelRateMonopropellant");
            this.fuelRateBipropellant = stats.func_74762_e("fuelRateBipropellant");
            this.fuelRateOxidizer = stats.func_74762_e("fuelRateOxidizer");
            this.fuelRateImpulse = stats.func_74762_e("fuelRateImpulse");
            this.fuelRateIon = stats.func_74762_e("fuelRateIon");
            this.fuelRateNuclearWorkingFluid = stats.func_74762_e("fuelRateNuclearWorkingFluid");
            this.fuelRateWarp = stats.func_74762_e("fuelRateWarp");
            this.fuelBaseRateMonopropellant = stats.func_74762_e("fuelBaseRateMonopropellant");
            this.fuelBaseRateBipropellant = stats.func_74762_e("fuelBaseRateBipropellant");
            this.fuelBaseRateOxidizer = stats.func_74762_e("fuelBaseRateOxidizer");
            this.fuelBaseRateImpulse = stats.func_74762_e("fuelBaseRateImpulse");
            this.fuelBaseRateIon = stats.func_74762_e("fuelBaseRateIon");
            this.fuelBaseRateNuclearWorkingFluid = stats.func_74762_e("fuelBaseRateNuclearWorkingFluid");
            this.fuelBaseRateWarp = stats.func_74762_e("fuelBaseRateWarp");
            if (stats.func_74764_b("dynStats")) {
                NBTTagCompound dynStats = stats.func_74775_l("dynStats");
                for (String key : dynStats.func_150296_c()) {
                    NBTBase obj = dynStats.func_74781_a(key);
                    if (obj instanceof NBTTagFloat) {
                        this.setStatTag(key, dynStats.func_74760_g(key));
                        continue;
                    }
                    if (!(obj instanceof NBTTagInt)) continue;
                    this.setStatTag(key, dynStats.func_74762_e(key));
                }
            }
            this.pilotSeatPos.x = stats.func_74762_e("playerXPos");
            this.pilotSeatPos.y = (short)stats.func_74762_e("playerYPos");
            this.pilotSeatPos.z = stats.func_74762_e("playerZPos");
            if (stats.func_74764_b("engineLoc")) {
                locations = stats.func_74759_k("engineLoc");
                for (int i = 0; i < locations.length; i += 3) {
                    this.addEngineLocation((float)locations[i] / 2.0f, (float)locations[i + 1] / 2.0f, (float)locations[i + 2] / 2.0f);
                }
            }
            if (stats.func_74764_b("passengerSeats")) {
                locations = stats.func_74759_k("passengerSeats");
                for (int i = 0; i < locations.length; i += 3) {
                    this.addPassengerSeat(locations[i], locations[i + 1], locations[i + 2]);
                }
            }
        }
    }
}

