/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;

public class DataStorage {
    private int data;
    private int maxData;
    private DataType dataType;
    private boolean locked;

    public DataStorage() {
        this.dataType = DataType.UNDEFINED;
        this.locked = false;
    }

    public DataStorage(DataType data) {
        this.dataType = data;
        this.locked = false;
    }

    public boolean setData(int data, DataType dataType) {
        if (this.dataType == DataType.UNDEFINED) {
            this.dataType = dataType;
        }
        if (dataType == DataType.UNDEFINED || dataType == this.dataType) {
            this.data = Math.min(data, this.maxData);
            return true;
        }
        return false;
    }

    public int getData() {
        return this.data;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public int getMaxData() {
        return this.maxData;
    }

    public void setMaxData(int maxData) {
        this.maxData = maxData;
        if (this.data > maxData) {
            this.data = maxData;
        }
    }

    public void lockDataType(DataType type) {
        boolean bl = this.locked = type != null;
        if (this.locked) {
            if (this.dataType != type) {
                this.data = 0;
            }
            this.dataType = type;
        } else if (this.data == 0) {
            this.dataType = DataType.UNDEFINED;
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int addData(int data, DataType dataType, boolean commit) {
        if (!this.locked && dataType == DataType.UNDEFINED || dataType == this.dataType || this.dataType == DataType.UNDEFINED) {
            if (this.dataType == DataType.UNDEFINED) {
                this.dataType = dataType;
            }
            int amountToAdd = Math.min(data, this.maxData - this.data);
            if (commit) {
                this.data += amountToAdd;
            }
            return amountToAdd;
        }
        return 0;
    }

    public int removeData(int data, boolean commit) {
        int dataRemoved = Math.min(data, this.data);
        if (commit) {
            this.data -= dataRemoved;
        }
        if (!this.locked && this.data == 0) {
            this.dataType = DataType.UNDEFINED;
        }
        return dataRemoved;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Data", this.data);
        nbt.func_74768_a("maxData", this.maxData);
        nbt.func_74768_a("DataType", this.dataType.ordinal());
        nbt.func_74757_a("locked", this.locked);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.data = nbt.func_74762_e("Data");
        this.maxData = nbt.func_74762_e("maxData");
        try {
            this.dataType = DataType.values()[nbt.func_74762_e("DataType")];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.dataType = DataType.UNDEFINED;
        }
        this.locked = nbt.func_74764_b("locked") ? nbt.func_74767_n("locked") : false;
    }

    public static enum DataType {
        UNDEFINED,
        DISTANCE,
        HUMIDITY,
        TEMPERATURE,
        COMPOSITION,
        ATMOSPHEREDENSITY,
        MASS;


        public String toString() {
            return "data." + this.name().toLowerCase(Locale.ENGLISH) + ".name";
        }
    }
}

