/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.unifine;

import com.ferreusveritas.unifine.CommonProxy;
import com.ferreusveritas.unifine.OptifineHandlerBase;
import com.ferreusveritas.unifine.ShaderState;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="unifine", name="Unifine", version="1.12.2-0.1.0", dependencies="after:thermaldynamics", acceptedMinecraftVersions="[1.12.2]")
public class Unifine {
    @Mod.Instance(value="unifine")
    public static Unifine instance;
    @SidedProxy(clientSide="com.ferreusveritas.unifine.ClientProxy", serverSide="com.ferreusveritas.unifine.CommonProxy")
    public static CommonProxy proxy;
    private static ArrayList<Function<Boolean, Void>> callbacks;
    private static ShaderState currentShaderState;
    private static String cachedShaderName;
    private static OptifineHandlerBase optifineHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        optifineHandler = proxy.initOptifineHandler();
        currentShaderState = this.determineShaderState();
        optifineHandler.preInit(event);
        if (Unifine.isOptifineInstalled()) {
            MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        }
        System.out.println("Unifine detected Optifine shader state: " + (Object)((Object)currentShaderState));
    }

    @Mod.EventHandler
    public void onMessageRecieved(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage mess : event.getMessages()) {
            Optional function;
            if (!"shadertest".equalsIgnoreCase(mess.key) || !(function = mess.getFunctionValue(Boolean.class, Void.class)).isPresent()) continue;
            Unifine.AddCallback((Function)function.get());
        }
    }

    public static void AddCallback(Function<Boolean, Void> function) {
        callbacks.add(function);
    }

    public static boolean isShaderActive() {
        return currentShaderState.DoesShading();
    }

    private ShaderState determineShaderState() {
        return optifineHandler.determineShaderState();
    }

    public static String getCurrentShaderName() {
        return optifineHandler.getCurrentShaderName();
    }

    public static ShaderState getCurrentShaderState() {
        return currentShaderState;
    }

    public static boolean isOptifineInstalled() {
        return currentShaderState != ShaderState.NULL;
    }

    private void shaderStateChanged() {
        System.out.println("Unifine detected an Optifine shader state change: " + (Object)((Object)currentShaderState) + " Name:" + Unifine.getCurrentShaderName());
        boolean isShaderActive = Unifine.isShaderActive();
        callbacks.forEach((Consumer<Function<Boolean, Void>>)((Consumer<Function>)a -> {
            Void cfr_ignored_0 = (Void)a.apply(isShaderActive);
        }));
        proxy.invalidateAllChunkMeshes();
    }

    public CommonEventHandler CreateEventHandler() {
        return new CommonEventHandler();
    }

    static {
        callbacks = new ArrayList();
        currentShaderState = ShaderState.NULL;
        cachedShaderName = "";
    }

    public class CommonEventHandler {
        @SubscribeEvent
        public void onWorldTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                String shaderName = Unifine.getCurrentShaderName();
                if (!cachedShaderName.equals(shaderName)) {
                    cachedShaderName = shaderName;
                    currentShaderState = Unifine.this.determineShaderState();
                    Unifine.this.shaderStateChanged();
                }
            }
        }
    }
}

