/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.IAudioConnection;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.computronics.reference.Capabilities;
import pl.asie.computronics.util.ColorUtils;
import pl.asie.lib.tile.TileEntityBase;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.internal.IColorable;

public class TileAudioCable
extends TileEntityBase
implements IAudioReceiver,
IColorable {
    private final HashSet<Object> packetIds = new HashSet();
    private long idTick = -1L;
    private int ImmibisMicroblocks_TransformableTileEntityMarker;
    private byte connectionMap = 0;
    private boolean initialConnect = false;
    protected int overlayColor = this.getDefaultColor();

    public void updateConnections() {
        byte oldConnections = this.connectionMap;
        this.connectionMap = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IColorable targetCol;
            IAudioConnection con;
            if (!this.connectsInternal(dir) || !this.field_145850_b.func_175667_e(this.func_174877_v().func_177972_a(dir))) continue;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (tile instanceof TileAudioCable) {
                if (!((TileAudioCable)tile).connectsInternal(dir.func_176734_d())) {
                    continue;
                }
            } else if (!(tile instanceof IAudioConnection) ? !Capabilities.hasAny((ICapabilityProvider)tile, dir.func_176734_d(), Capabilities.AUDIO_SOURCE_CAPABILITY, Capabilities.AUDIO_RECEIVER_CAPABILITY) || (con = (IAudioConnection)Capabilities.getFirst((ICapabilityProvider)tile, dir.func_176734_d(), Capabilities.AUDIO_SOURCE_CAPABILITY, Capabilities.AUDIO_RECEIVER_CAPABILITY)) == null || !con.connectsAudio(dir) : !((IAudioConnection)tile).connectsAudio(dir.func_176734_d())) continue;
            if ((targetCol = ColorUtils.getColorable((ICapabilityProvider)tile, dir.func_176734_d())) != null && targetCol.canBeColored() && !ColorUtils.isSameOrDefault(this, targetCol)) continue;
            this.connectionMap = (byte)(this.connectionMap | 1 << dir.ordinal());
        }
        if (this.connectionMap != oldConnections) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    protected boolean connectsInternal(EnumFacing dir) {
        return this.ImmibisMicroblocks_isSideOpen(dir.ordinal());
    }

    @Override
    public boolean connectsAudio(EnumFacing dir) {
        if (!this.initialConnect) {
            this.updateConnections();
            this.initialConnect = true;
        }
        return (this.connectionMap >> dir.ordinal() & 1) == 1;
    }

    public boolean receivePacketID(Object o) {
        if (!this.func_145830_o() || this.idTick == this.field_145850_b.func_82737_E()) {
            if (this.packetIds.contains(o)) {
                return false;
            }
        } else {
            this.idTick = this.field_145850_b.func_82737_E();
            this.packetIds.clear();
        }
        this.packetIds.add(o);
        return true;
    }

    @Override
    public void receivePacket(AudioPacket packet, @Nullable EnumFacing side) {
        if (!this.receivePacketID(packet.id)) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity tile;
            BlockPos pos;
            if (dir == side || !this.connectsAudio(dir) || !this.field_145850_b.func_175667_e(pos = this.func_174877_v().func_177972_a(dir)) || (tile = this.field_145850_b.func_175625_s(pos)) == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER_CAPABILITY, dir.func_176734_d())) continue;
            ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER_CAPABILITY, dir.func_176734_d())).receivePacket(packet, dir.func_176734_d());
        }
    }

    @Override
    public String getID() {
        return AudioUtils.positionId(this.func_174877_v());
    }

    @Override
    public World getSoundWorld() {
        return null;
    }

    @Override
    public Vec3d getSoundPos() {
        return Vec3d.field_186680_a;
    }

    @Override
    public int getSoundDistance() {
        return 0;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    public int getColor() {
        return this.overlayColor;
    }

    @Override
    public int getDefaultColor() {
        return ColorUtils.Color.LightGray.color;
    }

    @Override
    public void setColor(int color) {
        this.overlayColor = color;
        this.updateConnections();
        this.func_70296_d();
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound nbt) {
        super.readFromRemoteNBT(nbt);
        int oldColor = this.overlayColor;
        byte oldConnections = this.connectionMap;
        if (nbt.func_74764_b("col")) {
            this.overlayColor = nbt.func_74762_e("col");
        }
        if (this.overlayColor < 0) {
            this.overlayColor = this.getDefaultColor();
        }
        if (nbt.func_74764_b("con")) {
            this.connectionMap = nbt.func_74771_c("con");
        }
        if (oldColor != this.overlayColor || oldConnections != this.connectionMap) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public NBTTagCompound writeToRemoteNBT(NBTTagCompound nbt) {
        super.writeToRemoteNBT(nbt);
        if (this.overlayColor != this.getDefaultColor()) {
            nbt.func_74768_a("col", this.overlayColor);
        }
        nbt.func_74774_a("con", this.connectionMap);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("col")) {
            this.overlayColor = nbt.func_74762_e("col");
        }
        if (this.overlayColor < 0) {
            this.overlayColor = this.getDefaultColor();
        }
        if (nbt.func_74764_b("con")) {
            this.connectionMap = nbt.func_74771_c("con");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.overlayColor != this.getDefaultColor()) {
            nbt.func_74768_a("col", this.overlayColor);
        }
        nbt.func_74774_a("con", this.connectionMap);
        return nbt;
    }

    public boolean ImmibisMicroblocks_isSideOpen(int side) {
        return true;
    }

    public void ImmibisMicroblocks_onMicroblocksChanged() {
    }
}

