/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.cc.TurtlePeripheralBase;
import pl.asie.computronics.cc.TurtleUpgradeBase;
import pl.asie.computronics.util.NoteUtils;

public class MusicalTurtleUpgrade
extends TurtleUpgradeBase {
    protected final List<NoteUtils.NoteTask> noteBuffer = new ArrayList<NoteUtils.NoteTask>();

    public MusicalTurtleUpgrade(String id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ITurtleAccess turtle, TurtleSide side) {
        super.update(turtle, side);
        List<NoteUtils.NoteTask> list = this.noteBuffer;
        synchronized (list) {
            if (!this.noteBuffer.isEmpty()) {
                for (NoteUtils.NoteTask task : this.noteBuffer) {
                    task.play(turtle.getWorld(), turtle.getPosition());
                }
                this.noteBuffer.clear();
            }
        }
    }

    public String getUnlocalisedAdjective() {
        return "Musical";
    }

    public ItemStack getCraftingItem() {
        return new ItemStack((Block)Computronics.ironNote, 1, 0);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new MusicalTurtlePeripheral(turtle);
    }

    private class MusicalTurtlePeripheral
    extends TurtlePeripheralBase {
        public MusicalTurtlePeripheral(ITurtleAccess access) {
            super(access);
        }

        public String getType() {
            return "iron_noteblock";
        }

        @Optional.Method(modid="computercraft")
        public String[] getMethodNames() {
            return new String[]{"playNote"};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Optional.Method(modid="computercraft")
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            block14: {
                try {
                    NoteUtils.NoteTask task = null;
                    if (arguments.length >= 1) {
                        if (arguments.length >= 2 && arguments[1] instanceof Double) {
                            if (arguments[0] != null) {
                                if (arguments[0] instanceof Double) {
                                    task = NoteUtils.playNote(this.access.getWorld(), this.access.getPosition(), ((Double)arguments[0]).intValue(), ((Double)arguments[1]).intValue(), NoteUtils.toVolume(arguments, 2));
                                } else if (arguments[0] instanceof String) {
                                    task = NoteUtils.playNote(this.access.getWorld(), this.access.getPosition(), (String)arguments[0], ((Double)arguments[1]).intValue(), NoteUtils.toVolume(arguments, 2));
                                }
                            } else {
                                task = NoteUtils.playNote(this.access.getWorld(), this.access.getPosition(), -1, ((Double)arguments[1]).intValue(), NoteUtils.toVolume(arguments, 2));
                            }
                        } else if (arguments[0] instanceof Double) {
                            task = NoteUtils.playNote(this.access.getWorld(), this.access.getPosition(), -1, ((Double)arguments[0]).intValue(), NoteUtils.toVolume(arguments, 1));
                        }
                    }
                    if (task == null) break block14;
                    List<NoteUtils.NoteTask> list = MusicalTurtleUpgrade.this.noteBuffer;
                    synchronized (list) {
                        MusicalTurtleUpgrade.this.noteBuffer.add(task);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            return null;
        }
    }
}

