/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.capability.base;

import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.capability.base.EntityCapability;
import mob_grinding_utils.network.MessageSyncEntityCapabilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityCapabilityTracker {
    private final EntityCapability<?, ?, ?> entityCapability;
    private final EntityPlayerMP watcher;
    private boolean trackerReady = true;
    private int lastUpdate = 0;

    public EntityCapabilityTracker(EntityCapability<?, ?, ?> entityCapability, EntityPlayerMP watcher) {
        this.entityCapability = entityCapability;
        this.watcher = watcher;
    }

    public EntityPlayerMP getWatcher() {
        return this.watcher;
    }

    public EntityCapability<?, ?, ?> getEntityCapability() {
        return this.entityCapability;
    }

    public void update() {
        if (this.lastUpdate < this.entityCapability.getTrackingTime()) {
            ++this.lastUpdate;
        } else {
            this.trackerReady = true;
        }
        if (this.trackerReady && this.entityCapability.isDirty()) {
            this.lastUpdate = 0;
            this.trackerReady = false;
            this.entityCapability.setDirty(false);
            this.sendPacket();
        }
    }

    public void sendPacket() {
        MessageSyncEntityCapabilities message = new MessageSyncEntityCapabilities(this.entityCapability);
        MobGrindingUtils.NETWORK_WRAPPER.sendTo((IMessage)message, this.watcher);
    }
}

